/*
 * $Id:  $
 *
 * This file is part of the jcar (R) project.
 * Copyright (c) 2014-2018 北京益高亚太信息技术有限公司
 * Authors: laurent.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License
 * as published by the Free Software Foundation, either version 3 of
 * the License, or(at your option)any later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 * or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU Affero General Public License for more details.
 * You should have received a copy of the GNU Affero General Public License
 * along with this program; if not, see <http://www.gnu.org/licenses>
 */
package com.indigosoftware.idp.utilities.classloader;

import java.io.File;
import java.io.FilenameFilter;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;


public class ComponentClassloader extends URLClassLoader {
    private static ConcurrentMap<String, ComponentClassloader> context = new ConcurrentHashMap<String, ComponentClassloader>();

    static String[] filters = new String[] { "org.w3c" };

    private String componentPath;

    private boolean self = false;

    public ComponentClassloader(URL[] urls, ClassLoader parent, boolean self) throws Exception {
        super(urls, parent);
        this.self = self;
    }

    public ComponentClassloader(String componentPath, boolean self) throws Exception {
        super(new URL[] { (new File(componentPath)).toURI().toURL() });
        this.self = self;
    }

    public static ComponentClassloader getComponentClassloader(String componentPath) throws Exception {
        cleanCache();
        ComponentClassloader loader = null;
        if (context.get(componentPath) != null) {
            loader = context.get(componentPath);
            return loader;
        }
        if (loader == null) {
            List<URL> urls = new ArrayList<URL>();
            if ((new File(componentPath)).isDirectory()) {
                File[] files = (new File(componentPath)).listFiles(new FilenameFilter() {
                    @Override
                    public boolean accept(File dir, String name) {
                        if (name.endsWith(".jar")) {
                            return true;
                        }
                        return false;
                    }
                });
                if (files != null){
                    for (File file : files) {
                        urls.add(file.toURI().toURL());
                    }
                }
                urls.add((new File(componentPath)).toURI().toURL());
            } else {
                urls.add((new File(componentPath)).toURI().toURL());
            }
            loader = new ComponentClassloader(urls.<URL>toArray(new URL[urls.size()]), Thread.currentThread().getContextClassLoader(), false);
            context.putIfAbsent(componentPath, loader);
        }
        return context.get(componentPath);
    }

    public static ComponentClassloader getComponentClassloader(String componentPath, ClassLoader parent) throws Exception {
        cleanCache();
        ComponentClassloader loader = null;
        if (context.get(componentPath) != null) {
            loader = context.get(componentPath);
            return loader;
        }
        if (loader == null) {
            List<URL> urls = new ArrayList<URL>();
            if ((new File(componentPath)).isDirectory()) {
                File[] files = (new File(componentPath)).listFiles(new FilenameFilter() {
                    @Override
                    public boolean accept(File dir, String name) {
                        if (name.endsWith(".jar")) {
                            return true;
                        }
                        return false;
                    }
                });
                if (files != null) {
                    for (File file : files) {
                        urls.add(file.toURI().toURL());
                    }
                }
                urls.add((new File(componentPath)).toURI().toURL());
            } else {
                urls.add((new File(componentPath)).toURI().toURL());
            }
            loader = new ComponentClassloader(urls.<URL>toArray(new URL[urls.size()]), parent, false);
            context.putIfAbsent(componentPath, loader);
        }
        return context.get(componentPath);
    }

    public static ComponentClassloader getComponentClassloader(String componentPath, ClassLoader parent, boolean self) throws Exception {
        cleanCache();
        ComponentClassloader loader = null;
        if (context.get(componentPath) != null) {
            loader = context.get(componentPath);
            return loader;
        }
        if (loader == null) {
            List<URL> urls = new ArrayList<URL>();
            if ((new File(componentPath)).isDirectory()) {
                File[] files = (new File(componentPath)).listFiles(new FilenameFilter() {
                    @Override
                    public boolean accept(File dir, String name) {
                        if (name.endsWith(".jar")) {
                            return true;
                        }
                        return false;
                    }
                });
                if (files != null) {
                    for (File file : files) {
                        urls.add(file.toURI().toURL());
                    }
                }
                urls.add((new File(componentPath)).toURI().toURL());
            } else {
                urls.add((new File(componentPath)).toURI().toURL());
            }
            loader = new ComponentClassloader(urls.<URL>toArray(new URL[urls.size()]), parent, self);
            context.putIfAbsent(componentPath, loader);
        }
        return context.get(componentPath);
    }

    public static void main(String[] args) throws Exception {
        getComponentClassloader("com");
    }

    private static void cleanCache() {}

    @Override
    protected synchronized Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
        Class<?> c = findLoadedClass(name);
        if (c == null) {
            if (this.self && !filter(name)) {
                try {
                    c = findClass(name);
                } catch (ClassNotFoundException e) {
                    if (getParent() != null) {
                        c = getParent().loadClass(name);
                    }
                }
            } else {
                try {
                    if (getParent() != null) {
                        c = getParent().loadClass(name);
                    }
                } catch (ClassNotFoundException e) {
                    c = findClass(name);
                }
            }
        }
        if (resolve) {
            resolveClass(c);
        }
        return c;
    }

    private boolean filter(String name) {
        for (String pack : filters) {
            if (name.startsWith(pack)) {
                return true;
            }
        }
        return false;
    }
}
