/*
 * $Id:  $
 *
 * This file is part of the jcar (R) project.
 * Copyright (c) 2014-2018 北京益高亚太信息技术有限公司
 * Authors: laurent.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License
 * as published by the Free Software Foundation, either version 3 of
 * the License, or(at your option)any later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 * or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU Affero General Public License for more details.
 * You should have received a copy of the GNU Affero General Public License
 * along with this program; if not, see <http://www.gnu.org/licenses>
 */
package com.indigosoftware.idp.component.agent.dsignature.util;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;

import org.dom4j.Document;
import org.dom4j.io.SAXReader;


public class IOUtil {

    
	public static byte[] toBytes(InputStream ins) throws IOException {
		byte[] bytes = new byte[512];
		ByteArrayOutputStream bos = new ByteArrayOutputStream();
		int len = -1;
		while ((len = ins.read(bytes)) != -1) {
			bos.write(bytes, 0, len);
		}
		return bos.toByteArray();
	}

	
	public static void skip(InputStream ins, long skip) throws IOException {
		long realSkip = 0;
		long skipCount = 0;
		do {
			realSkip = ins.skip(skip - skipCount);
			skipCount += realSkip;
		} while (skipCount < skip && ins.available() > 0);
	}

	
	/**
	 * inputStream convert to outputStream
	 * 
	 * @param ins
	 * @param out
	 * @throws IOException
	 */
	public static void inputStream2OutputStream(InputStream ins,
			OutputStream out) throws IOException {
		byte[] b = new byte[512];
		int len = -1;
		while ((len = ins.read(b)) != -1) {
			out.write(b, 0, len);
		}
	}

	
	public short readShort(InputStream ins, ByteOrder byteOrder)
			throws IOException {
		ByteBuffer bInt = ByteBuffer.allocate(2);
		byte[] b2 = new byte[2];
		bInt.order(byteOrder);
		int i = ins.read(b2, 0, 2);
		if (i != 2) {
			throw new IOException("read stream short error,i=" + i);
		}
		bInt.put(b2);
		return bInt.getShort(0);
	}

	
	public static int readInputStream(InputStream ins, byte[] bytes, int len)
			throws IOException {
		int tmpLen = 0, realLen = 0;
		while (len != realLen) {
			tmpLen = ins.read(bytes, realLen, len - realLen);
			if (tmpLen < -1) {
				throw new IOException("read inputStream error");
			} else if (tmpLen == 0) {
				return realLen;
			}
			realLen += tmpLen;
		}
		return realLen;
	}
	
	
	public static Document getDocument(InputStream is)
			throws Exception {
			if (is == null) {
				throw new Exception("Param exception, InputStream 'is' is null");
			}

			is.mark(0);
			SAXReader sBuilder = new SAXReader();
			Document doc = sBuilder.read(is);

			if (doc == null) {
				throw new Exception("Xml format error for: get Document");
			}

			is.reset();
			return doc;
	}

}
