/*
 * $Id:  $
 *
 * This file is part of the jcar (R) project.
 * Copyright (c) 2014-2018 北京益高亚太信息技术有限公司
 * Authors: laurent.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License
 * as published by the Free Software Foundation, either version 3 of
 * the License, or(at your option)any later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 * or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU Affero General Public License for more details.
 * You should have received a copy of the GNU Affero General Public License
 * along with this program; if not, see <http://www.gnu.org/licenses>
 */
package com.indigosoftware.idp.component.agent.dsignature.util;

/**
 * <p>
 * </p>
 * <p>
 * Standard Base64
 * </p>
 * @version V1.0
 */

public class Base64 {
	/** Base64 Code Tabel */
	private static char Base64Code[] = { 'A', 'B', 'C', 'D', 'E', 'F', 'G',
			'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T',
			'U', 'V', 'W', 'X', 'Y', 'Z', 'a', 'b', 'c', 'd', 'e', 'f', 'g',
			'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't',
			'u', 'v', 'w', 'x', 'y', 'z', '0', '1', '2', '3', '4', '5', '6',
			'7', '8', '9', '+', '/', };

	/** Base64 decode table */
	private static byte Base64Decode[] = { -1, -1, -1, -1, -1, -1, -1, -1, -1,
			-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
			-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
			62, -1, 63, -1, 63, // "/"&"-" r translated to 63
			52, 53, 54, 55, 56, 57, 58, 59, 60, 61, -1, -1, -1, 0, -1, -1, -1,
			0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, // "A"&"=" r
																// translated to
																// 0
			15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, -1, -1, -1, -1, -1, -1,
			26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42,
			43, 44, 45, 46, 47, 48, 49, 50, 51, -1, -1, -1, -1, -1, };

	/**
	 * private Construction Func
	 */
	private Base64() {
	}

	/**
	 * Base64 Encode��every 3 bytes to 4 bytes eyeable
	 * 
	 * @param b
	 *            source byte array
	 * @return Base64 String
	 */
	public static String encode(byte[] b) {
		int code = 0;

		// Use ram by actual codes
		StringBuffer sb = new StringBuffer(((b.length - 1) / 3) << 2 + 4);

		// encoding
		for (int i = 0; i < b.length; i++) {
			code |= (b[i] << (16 - i % 3 * 8)) & (0xff << (16 - i % 3 * 8));
			if (i % 3 == 2 || i == b.length - 1) {
				sb.append(Base64Code[(code & 0xfc0000) >>> 18]);
				sb.append(Base64Code[(code & 0x3f000) >>> 12]);
				sb.append(Base64Code[(code & 0xfc0) >>> 6]);
				sb.append(Base64Code[code & 0x3f]);
				code = 0;
			}
		}

		// if the array is not the times of 3,before encoding add "o" to the
		// array,after encoding add "=" to the end
		// the number of "=" is equal with the short��so that to show the actual
		// length of data
		if (b.length % 3 > 0) {
			sb.setCharAt(sb.length() - 1, '=');
		}
		if (b.length % 3 == 1) {
			sb.setCharAt(sb.length() - 2, '=');
		}
		return sb.toString();
	}

	/**
	 * Base64 decode
	 * 
	 * @param code
	 *            the ASCII String encoded with Base64
	 * @return the byte array decoded
	 */
	public static byte[] decode(String code) {

		// check the param
		if (code == null) {
			return null;
		}
		int len = code.length();
		if (len % 4 != 0) {
			throw new IllegalArgumentException(
					"Base64 string length must be 4*n");
		}
		if (code.length() == 0) {
			return new byte[0];
		}

		// count the "="
		int pad = 0;
		if (code.charAt(len - 1) == '=') {
			pad++;
		}
		if (code.charAt(len - 2) == '=') {
			pad++;
		}

		// accout the actual length of data by number of "="
		int retLen = len / 4 * 3 - pad;

		// assign the ram
		byte[] ret = new byte[retLen];

		// decoding the code by looking up the decode table
		char ch1, ch2, ch3, ch4;
		int i;
		for (i = 0; i < len; i += 4) {
			int j = i / 4 * 3;
			ch1 = code.charAt(i);
			ch2 = code.charAt(i + 1);
			ch3 = code.charAt(i + 2);
			ch4 = code.charAt(i + 3);
			int tmp = (Base64Decode[ch1] << 18) | (Base64Decode[ch2] << 12)
					| (Base64Decode[ch3] << 6) | (Base64Decode[ch4]);
			ret[j] = (byte) ((tmp & 0xff0000) >> 16);
			if (i < len - 4) {
				ret[j + 1] = (byte) ((tmp & 0x00ff00) >> 8);
				ret[j + 2] = (byte) ((tmp & 0x0000ff));
			} else {
				if (j + 1 < retLen) {
					ret[j + 1] = (byte) ((tmp & 0x00ff00) >> 8);
				}
				if (j + 2 < retLen) {
					ret[j + 2] = (byte) ((tmp & 0x0000ff));
				}
			}
		}
		return ret;
	}

}