/*
 * $Id:  $
 *
 * This file is part of the jcar (R) project.
 * Copyright (c) 2014-2018 北京益高亚太信息技术有限公司
 * Authors: laurent.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License
 * as published by the Free Software Foundation, either version 3 of
 * the License, or(at your option)any later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 * or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU Affero General Public License for more details.
 * You should have received a copy of the GNU Affero General Public License
 * along with this program; if not, see <http://www.gnu.org/licenses>
 */
package com.indigosoftware.idp.component.agent.dsignature.signaturedevices;


import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

import com.indigosoftware.adapter.jce.common.SignatureDevice;
import com.indigosoftware.idp.component.agent.dsignature.factory.SignatureDeviceFactory;


public class LocalSignatureDeviceManager implements SignatureDeviceManager {

	private ConcurrentHashMap<String, SignatureDevice> devices = new ConcurrentHashMap<String, SignatureDevice>();
	
	@Override
	public void initialize(Map<String, Object> parameters) {
		// TODO Auto-generated method stub 

	}

	@Override
	public SignatureDevice getDevice(String name, String type) throws Exception {

		SignatureDevice signatureDevice = devices.get(name);
		if(signatureDevice != null){
			return signatureDevice;
		}

		try{
			signatureDevice = SignatureDeviceFactory.getSignatureDevice(type);
		}catch(Exception e){
			throw e;
		}
		devices.putIfAbsent(name, signatureDevice);
		signatureDevice = devices.get(name);
		
		return signatureDevice;
	}

	@Override
	public void destroy() {
		for (SignatureDevice device : devices.values()) {
			device.destroy();
		}
		devices.clear();
	}

	
}
