/*
 * $Id:  $
 *
 * This file is part of the jcar (R) project.
 * Copyright (c) 2014-2018 北京益高亚太信息技术有限公司
 * Authors: laurent.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License
 * as published by the Free Software Foundation, either version 3 of
 * the License, or(at your option)any later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 * or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU Affero General Public License for more details.
 * You should have received a copy of the GNU Affero General Public License
 * along with this program; if not, see <http://www.gnu.org/licenses>
 */
package com.indigosoftware.idp.component.agent.dsignature.factory;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

import com.indigopacific.module.model.Signature;
import org.apache.commons.io.IOUtils;
import org.apache.log4j.Logger;
import org.dom4j.*;
import org.dom4j.io.SAXReader;

import com.indigosoftware.idp.component.agent.dsignature.engine.DigitalSignatureEngine;
import com.indigosoftware.idp.component.agent.dsignature.signaturedevices.SignatureDeviceManager;
import com.indigosoftware.idp.component.agent.dsignature.util.DigitalAssist;


public enum WorkMode {


	/** 签名/签章模式 */
	SIGN {

		@Override
		public void execute(Object in, String out, String fileType, SignatureDeviceManager deviceManager, Map<String, Object> parameters) throws Exception {

			if(in instanceof String){
				logger.info("Dsignature start to run SIGN mode,the IN is [{"+in+"}],the OUT is [{"+out+"}],the fileType is [{"+fileType+"}]");
			}

			String configFile = (String) parameters.get("configFile");
			String configString = (String) parameters.get("configString");
			
			if (configFile == null && configString == null){
				Exception ie = new Exception("The parameter configFile / configString must be supplied");
				throw ie;
			}
			
			if (configFile != null && !new File(configFile).isFile()) {
				Exception ie = new Exception( "The configFile[{"+configFile+"}] not existed");
				throw ie;
			}

			Document doc = null;
			
			if (configFile != null){
				try {
					SAXReader reader = new SAXReader();
					doc = reader.read(new File(configFile));
				} catch (DocumentException e) {
					throw e;
				}
			}else{
				try {
					doc = DocumentHelper.parseText(configString);
				} catch (DocumentException e) {
					throw e;
				}
			}
			InputStream fis = null;
			FileOutputStream fos = null;

			try {

				List<Node> signatures = doc.selectNodes("//DigitalSignature/Signature");
				int signatureSize = signatures.size();

				if (signatureSize < 1) {
					return;
				}

				DigitalSignatureEngine engine = DigitalSignatureFactory.getSignatureEngine(fileType, parameters);
				if(in instanceof String){
					fis = new FileInputStream((String) in);
				}else{
					fis = (InputStream) in;
				}
				byte[] bytes = DigitalAssist.streamToByteArray(fis);

				List<Signature> signatureList = new ArrayList<Signature>();

				for (int i = 0; i < signatureSize; i++) {
					Element signatureDef = (Element) signatures.get(i);

					Signature signature = new Signature(signatureDef);
					signatureList.add(signature);
				}

				for (int i = 0; i < signatureSize; i++) {
					bytes = engine.sign(bytes, deviceManager, signatureList.get(i));
				}

				fos = new FileOutputStream(out);
				fos.write(bytes);
			} catch (Exception e) {
				//文档{inFile}签名失败，失败原因{CatchedException}”。
				throw e;
			} finally {
				deviceManager.destroy();
				IOUtils.closeQuietly(fis);
				IOUtils.closeQuietly(fos);
			}

			logger.info("Dsignature run the SIGN mode end ,the OUT is [{"+out+"}],the fileType is [{"+fileType+"}]");

		}
	};


	public final static Logger logger = Logger.getLogger(WorkMode.class);


	public abstract void execute(Object in, String out, String fileType, SignatureDeviceManager deviceManager, Map<String, Object> parameters) throws Exception;

	
	public static WorkMode getValue(String workMode) {
		if(workMode.toUpperCase().equals("SIGN")){
			return SIGN;
		};
		return null;
	}

}
