/*
 * $Id:  $
 *
 * This file is part of the jcar (R) project.
 * Copyright (c) 2014-2018 北京益高亚太信息技术有限公司
 * Authors: laurent.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License
 * as published by the Free Software Foundation, either version 3 of
 * the License, or(at your option)any later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 * or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU Affero General Public License for more details.
 * You should have received a copy of the GNU Affero General Public License
 * along with this program; if not, see <http://www.gnu.org/licenses>
 */
package com.indigosoftware.idp.component.agent.dsignature.factory;

import java.io.File;
import java.io.IOException;

import com.indigosoftware.adapter.jce.common.SignatureDevice;
import com.indigosoftware.idp.utilities.classloader.*;
import org.apache.log4j.Logger;

/**
 * 存储设备工厂类 用于通过设备(私钥存储设备)名获取设备
 *
 */

public class SignatureDeviceFactory {

	private static Logger logger = Logger.getLogger(SignatureDeviceFactory.class);
	
//	private static ClassLoader deviceCommonCL = null;
	

	/**
	 * 通过设备(私钥存储设备)名查找出对应设备。
	 * 
	 * @param dev
	 * @return StorageDevices
	 * @throws Exception
	 */
	public static SignatureDevice getSignatureDevice(String dev) throws Exception {
		SignatureDevice device = null;
		Class clazz = null;
		try{
			clazz = SignatureDeviceFinder.findDevice(dev);
			device = (SignatureDevice) clazz.newInstance();
			System.out.println("device created by ds classloader");
		}catch(Exception e){
			String adapterName = dev.substring(dev.lastIndexOf(".") + 1);
			File apapterPath = new File(System.getProperty("SignatureDevice"), adapterName);
			if(!apapterPath.exists()){
				String path = System.getProperty("SignatureDevice." + adapterName);
				if(path == null){
					System.out.println("adapterPath:" + apapterPath.getAbsolutePath());
					throw new IOException("System.getProperty(SignatureDevice) == " + System.getProperty("SignatureDevice"));
				}
				apapterPath = new File(path);
				if(!apapterPath.exists()){
					throw new IOException("adapter:" + dev + " path is not found");
				}
			}

//			ClassLoader loader = new ComponentClassloader(apapterPath.getAbsolutePath(), true);
			ClassLoader loader = ComponentClassloader.getComponentClassloader(apapterPath.getAbsolutePath());
			clazz = loader.loadClass(dev);
			device = (SignatureDevice) clazz.newInstance();
			System.out.println("device created by device classloader: " + loader.getClass().getSimpleName() + ", " + apapterPath.getAbsolutePath());
		}
		return device;
	}
	
	
}
