/*
 * $Id:  $
 *
 * This file is part of the jcar (R) project.
 * Copyright (c) 2014-2018 北京益高亚太信息技术有限公司
 * Authors: laurent.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License
 * as published by the Free Software Foundation, either version 3 of
 * the License, or(at your option)any later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 * or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU Affero General Public License for more details.
 * You should have received a copy of the GNU Affero General Public License
 * along with this program; if not, see <http://www.gnu.org/licenses>
 */
package com.indigosoftware.idp.component.agent.dsignature.factory;

import java.io.File;
import java.util.HashMap;
import java.util.Map;

import com.indigosoftware.idp.component.agent.dsignature.engine.DigitalSignatureEngine;
import org.apache.log4j.Logger;

/**
 * 数字签名工厂类 用于通过文件对象获取引擎
 * 
 * @author richard.zhang
 * @since 2011.3.22
 */

public class DigitalSignatureFactory {

	private static Logger logger = Logger.getLogger(DigitalSignatureFactory.class);

	// 用于缓存文件类型和其对应的Class
	private static HashMap<String, Class<DigitalSignatureEngine>> cache = new HashMap<String, Class<DigitalSignatureEngine>>();


	/**
	 * 通过文件类型查找出对应的处理引擎，并将其Class放入缓存。
	 * 
	 * @param fileType
	 * @param parameters 
	 * @return SignDSEngine
	 * @throws Exception
	 */
	public synchronized static DigitalSignatureEngine getSignatureEngine(String fileType, Map<String, Object> parameters) throws Exception {
		DigitalSignatureEngine engine = null;
		String seal = (String)parameters.get("seal");
		Class<DigitalSignatureEngine> clazz = cache.get(fileType.toUpperCase() + new File(seal).isFile());
		try {
			if (clazz == null) {
				clazz = SignatureEngineFinder.findEngine(fileType, seal);
				cache.put(fileType.toUpperCase() + new File(seal).isFile(), clazz);
			}
			engine = (DigitalSignatureEngine) clazz.newInstance();
			engine.setParameters(parameters);
		} catch (ClassNotFoundException e) {
			throw e;
		} catch (Exception e) {
			throw e;
		}
		return engine;
	}

}
