/*
 * $Id:  $
 *
 * This file is part of the jcar (R) project.
 * Copyright (c) 2014-2018 北京益高亚太信息技术有限公司
 * Authors: laurent.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License
 * as published by the Free Software Foundation, either version 3 of
 * the License, or(at your option)any later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 * or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU Affero General Public License for more details.
 * You should have received a copy of the GNU Affero General Public License
 * along with this program; if not, see <http://www.gnu.org/licenses>
 */
package com.indigosoftware.idp.component.agent.dsignature.engine;


import java.io.File;

public class SealPosition {
    // 正确的换算应该是从point到mm
    public static final float POINT_TO_MM = 25.4f / 72.0f;

    public static final float inch2mm = 25.400051F;
    public static final float mm2inch = 0.03937008F;
    public static final int dpi_default = 72;
    private float x;

    private float y;

    private float offsetX;

    private float offsetY;

    private int align;

    private String key;

    private int page = -1;

    private int dpi;

    private float width;

    private float height;

    public SealPosition() {
    }

    public SealPosition(SealPosition sealPosition) {
        if (sealPosition != null) {
            this.x = sealPosition.getX();
            this.y = sealPosition.getY();
            this.offsetX = sealPosition.getOffsetX();
            this.offsetY = sealPosition.getOffsetY();
            this.align = sealPosition.getAlign();
            this.key = sealPosition.getKey();
            this.page = sealPosition.getPage();
            this.dpi = sealPosition.getDpi();
            this.width = sealPosition.getWidth();
            this.height = sealPosition.getHeight();
        }
    }


    public String getKey() {
        return key;
    }

    public void setKey(String key) {
        this.key = key;
    }

    public int getAlign() {
        return align;
    }

    public void setAlign(int align) {
        this.align = align;
    }

    public float getY() {
        return y;
    }

    public void setY(float y) {
        this.y = y;
    }

    public float getX() {
        return x;
    }

    public void setX(float x) {
        this.x = x;
    }

    public int getPage() {
        return page;
    }

    public void setPage(int page) {
        this.page = page;
    }

    public float getOffsetX() {
        return offsetX;
    }

    public void setOffsetX(float offsetX) {
        this.offsetX = offsetX;
    }

    public float getOffsetY() {
        return offsetY;
    }

    public void setOffsetY(float offsetY) {
        this.offsetY = offsetY;
    }

    public int getDpi() {
        return dpi;
    }

    public void setDpi(int dpi) {
        this.dpi = dpi;
    }

    public float getWidth() {
        return width;
    }

    public void setWidth(float width) {
        this.width = width;
    }

    public float getHeight() {
        return height;
    }

    public void setHeight(float height) {
        this.height = height;
    }

    /**
     * 通过用印配置文件更新位置信息：
     * <?xml version="1.0" encoding="UTF-8"?>
     * <Seal>
     *     <X></X>
     *     <Y></Y>
     *     <OffsetX></OffsetX>
     *     <OffsetY></OffsetY>
     *     <Align></Align>
     *     <Key></Key>
     *     <Dpi>150</Dpi>
     * </Seal>
     * @param sealPosition
     *
     */
    public void update(String sealPosition) throws Exception {
        if (sealPosition == null || sealPosition.trim().isEmpty()) {
            return;
        }


            javax.xml.parsers.DocumentBuilderFactory factory = javax.xml.parsers.DocumentBuilderFactory.newInstance();
            javax.xml.parsers.DocumentBuilder builder = factory.newDocumentBuilder();
            org.w3c.dom.Document document = builder.parse(new File(sealPosition));

            org.w3c.dom.Element root = document.getDocumentElement();

            // 解析X坐标
            org.w3c.dom.NodeList xNodes = root.getElementsByTagName("X");
            if (xNodes.getLength() > 0 && xNodes.item(0).getTextContent() != null && !xNodes.item(0).getTextContent().trim().isEmpty()) {
                this.x = Float.parseFloat(xNodes.item(0).getTextContent().trim());
            }

            // 解析Y坐标
            org.w3c.dom.NodeList yNodes = root.getElementsByTagName("Y");
            if (yNodes.getLength() > 0 && yNodes.item(0).getTextContent() != null && !yNodes.item(0).getTextContent().trim().isEmpty()) {
                this.y = Float.parseFloat(yNodes.item(0).getTextContent().trim());
            }

            // 解析OffsetX
            org.w3c.dom.NodeList offsetXNodes = root.getElementsByTagName("OffsetX");
            if (offsetXNodes.getLength() > 0 && offsetXNodes.item(0).getTextContent() != null && !offsetXNodes.item(0).getTextContent().trim().isEmpty()) {
                this.offsetX = Float.parseFloat(offsetXNodes.item(0).getTextContent().trim());
            }

            // 解析OffsetY
            org.w3c.dom.NodeList offsetYNodes = root.getElementsByTagName("OffsetY");
            if (offsetYNodes.getLength() > 0 && offsetYNodes.item(0).getTextContent() != null && !offsetYNodes.item(0).getTextContent().trim().isEmpty()) {
                this.offsetY = Float.parseFloat(offsetYNodes.item(0).getTextContent().trim());
            }

            // 解析Width
            org.w3c.dom.NodeList widthNodes = root.getElementsByTagName("Width");
            if (widthNodes.getLength() > 0 && widthNodes.item(0).getTextContent() != null && !widthNodes.item(0).getTextContent().trim().isEmpty()) {
                this.width = Float.parseFloat(widthNodes.item(0).getTextContent().trim());
            }

            // 解析OffsetY
            org.w3c.dom.NodeList heightNodes = root.getElementsByTagName("Height");
            if (heightNodes.getLength() > 0 && heightNodes.item(0).getTextContent() != null && !heightNodes.item(0).getTextContent().trim().isEmpty()) {
                this.height = Float.parseFloat(heightNodes.item(0).getTextContent().trim());
            }

            // 解析Align
            org.w3c.dom.NodeList alignNodes = root.getElementsByTagName("Align");
            if (alignNodes.getLength() > 0 && alignNodes.item(0).getTextContent() != null && !alignNodes.item(0).getTextContent().trim().isEmpty()) {
                this.align = Integer.parseInt(alignNodes.item(0).getTextContent().trim());
            }

            // 解析Key
            org.w3c.dom.NodeList keyNodes = root.getElementsByTagName("Key");
            if (keyNodes.getLength() > 0 && keyNodes.item(0).getTextContent() != null) {
                this.key = keyNodes.item(0).getTextContent().trim();
            }

            // 解析Dpi
            org.w3c.dom.NodeList dpiNodes = root.getElementsByTagName("Dpi");
            if (dpiNodes.getLength() > 0 && dpiNodes.item(0).getTextContent() != null && !dpiNodes.item(0).getTextContent().trim().isEmpty()) {
                this.dpi = Integer.parseInt(dpiNodes.item(0).getTextContent().trim());
            }
    }
}
