/*
 * $Id:  $
 *
 * This file is part of the jcar (R) project.
 * Copyright (c) 2014-2018 北京益高亚太信息技术有限公司
 * Authors: laurent.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License
 * as published by the Free Software Foundation, either version 3 of
 * the License, or(at your option)any later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 * or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU Affero General Public License for more details.
 * You should have received a copy of the GNU Affero General Public License
 * along with this program; if not, see <http://www.gnu.org/licenses>
 */
package com.indigosoftware.idp.component.agent.dsignature.engine;

import java.util.Map;


import com.indigopacific.module.model.Signature;
import com.indigosoftware.adapter.jce.common.SignatureDevice;
import com.indigosoftware.idp.component.agent.dsignature.signaturedevices.SignatureDeviceManager;


public interface DigitalSignatureEngine {
    
    
    /**
     * 添加签名引擎参数
     * @param parameters
     * @throws Exception
     */
    void setParameters(Map<String, Object> parameters) throws Exception;
    

	/**
	 * 对文档添加数字签名
	 * 
	 * @param bytes
	 *        文档的字节数组
	 * @param manager
	 *        存储设备管理对象
	 * @param signature
	 *        数字签名对象
	 * @return
	 * @throws Exception
	 */
	byte[] sign(byte[] bytes, SignatureDeviceManager manager, Signature signature) throws Exception;


	/**
	 * 生成指定签名版本的PDF文件
	 * @param in
	 * @param out
	 * @param revision
	 * @throws Exception 
	 */
	void getRevision(String in, String out, int revision) throws Exception;

}
