/*
 * $Id:  $
 *
 * This file is part of the jcar (R) project.
 * Copyright (c) 2014-2018 北京益高亚太信息技术有限公司
 * Authors: laurent.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License
 * as published by the Free Software Foundation, either version 3 of
 * the License, or(at your option)any later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 * or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU Affero General Public License for more details.
 * You should have received a copy of the GNU Affero General Public License
 * along with this program; if not, see <http://www.gnu.org/licenses>
 */
package com.indigosoftware.idp.component.agent.dsignature;

import java.io.File;
import java.util.Map;

import org.apache.commons.io.FileUtils;

import com.indigosoftware.idp.component.agent.dsignature.factory.WorkMode;
import com.indigosoftware.idp.component.agent.dsignature.signaturedevices.LocalSignatureDeviceManager;
import com.indigosoftware.idp.component.agent.dsignature.signaturedevices.SignatureDeviceManager;
import org.apache.log4j.Logger;


public class IDPDSignature {

	private static Logger logger = Logger.getLogger(IDPDSignature.class);

	public SignatureDeviceManager deviceManager = null;
	/**
	 * 数字签名相关操作Agent入口
	 * @param parameters
	 * @throws Exception
	 */
	public void execute(Map<String, Object> parameters) throws Exception { 
		//parameters.put("isLocal", true);
		if(parameters.get("isLocal") != null && parameters.get("isLocal").equals(true) ){
			deviceManager = new LocalSignatureDeviceManager();
		}
		Object in = null;
		String out = null;
		boolean _delinput = false;
		String fileType = null;
		WorkMode mode = null;
		boolean isTemp = false;
		try {
			logger.debug("Dsignature validate parameter", null);
			if(parameters.containsKey("inStream")){
				in = parameters.get("inStream");
			}else if (parameters.containsKey("inFile")) {
				in = (String) parameters.get("inFile");
				if(!new File((String) in).isFile()){
					Exception ie = new Exception("The parameter inFile[{inFile}] is not existed");
					throw ie;
				}
			} else {
				Exception ie = new Exception("The parameter inFile must be supplied");
				throw ie;
			}

			if (parameters.get("outFile") == null) {
				isTemp = true;
				File outFile = File.createTempFile("Signature", ".pdf");
				if (!outFile.getParentFile().exists()) {
					if (!outFile.getParentFile().mkdirs()) {
						Exception ie = new Exception("The parameters outFile invalid");
						throw ie;
					}
				}
				out = outFile.getAbsolutePath();
				logger.info("IDPDSignature set inFile to outFile", null);
			} else {
				out = (String) parameters.get("outFile");
				File outFile = new File(out);
				if (!outFile.getParentFile().exists()) {
					if (!outFile.getParentFile().mkdirs()) {
						Exception ie = new Exception( "The parameters outFile invalid");
						throw ie;
					}
				}
			}

			if (parameters.get("fileType") != null) {
				fileType = (String) parameters.get("fileType");
			} else {
				fileType = "PDF";
				logger.debug("IDPDSignature set fileType to default value[PDF]", null);
			}
			if(parameters.get("deleteInFile")!= null && parameters.get("deleteInFile") instanceof Boolean){
				if ((Boolean) parameters.get("deleteInFile")) {
					_delinput = true;
				}
			}
			

			if(parameters.get("workMode") != null){
				mode = WorkMode.getValue((String) parameters.get("workMode"));
			}

			if(mode == null){
				Exception ie = new Exception("The parameters workMode[{workMode}] invalid, please specified  workMode [Sign, Verify, getRevision]");
				throw ie;
			}
			
			mode.execute(in, out, fileType, deviceManager, parameters);
			
			
		} catch (Throwable e) {
			logger.error("IDPDsignature agent execute failed, errorMessage = [{message}]", e);
			throw new Exception(e);
		} finally {
			if (_delinput) {
				if(in instanceof String){
					new File((String) in).delete();
				}
			}
		}
		
		if(isTemp){
			if(in instanceof String){
				new File((String) in).delete();
				FileUtils.moveFile(new File(out), new File((String) in));
			}
			
		}

	}
	
	
	/**
	 * 中断Agent处理
	 * @throws Exception
	 */
	public void cancel() throws Exception{
		logger.info("IDPDsignature cancel() is called, begin to destory signatureDevices", null);
		deviceManager.destroy();
	}

}
