/*
 * $Id:  $
 *
 * This file is part of the jcar (R) project.
 * Copyright (c) 2014-2018 北京益高亚太信息技术有限公司
 * Authors: laurent.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License
 * as published by the Free Software Foundation, either version 3 of
 * the License, or(at your option)any later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 * or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU Affero General Public License for more details.
 * You should have received a copy of the GNU Affero General Public License
 * along with this program; if not, see <http://www.gnu.org/licenses>
 */

package com.indigosoftware.adapter.jce;

import com.indigosoftware.adapter.jce.common.SignatureDevice;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.jce.provider.X509CertParser;

import java.io.ByteArrayInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.security.*;
import java.security.cert.Certificate;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Map;

public class JKSAdapter extends SignatureDevice  {

    private static volatile Boolean loaded = Boolean.valueOf(false);

    private PrivateKey key;

    @Override
    public void initialize(Map<String, String> map) throws Exception {
        FileInputStream fis = null;
        try {
            String pkFile = map.get("pkFile");
            if (pkFile == null || "".equals(pkFile)) {
                throw new Exception("The parameters pkFile must be supplied if the mode is keystore");
            }
            this.parameters.put("keyStoreFile", pkFile);
            this.provider = "JKS";

            String ksPWD = map.get("ksPWD");
            if (ksPWD == null) {
                throw new Exception("The parameters ksPWD must be supplied if the mode is keystore");
            }
            this.parameters.put("keyStorePWD", ksPWD);

            String pkName = map.get("pkName");
            if (pkName == null || "".equals(pkName)) {
                throw new Exception("The parameters pkName must be supplied if the mode is keystore");
            }
            String pkPWD = map.get("pkPWD");
            if (pkPWD == null) {
                throw new Exception("The parameters pkPWD must be supplied if the mode is keystore");
            }
            if (!loaded.booleanValue()) {
                synchronized (loaded) {
                    if (!loaded.booleanValue()) {
                        Security.addProvider((Provider) new BouncyCastleProvider());
                        loaded = Boolean.valueOf(true);
                    }
                }
            }
            fis = new FileInputStream(pkFile);
            try {
                this.keyStore = KeyStore.getInstance("JKS");
            } catch (Exception e) {
                throw e;
            }
            this.keyStore.load(fis, ksPWD.toCharArray());
            PrivateKey key = (PrivateKey)this.keyStore.getKey(pkName, pkPWD.toCharArray());
            if (key == null) {
                String message = String.valueOf(pkName) + " can't found ,keyStore listed as ";
                Enumeration<String> en = this.keyStore.aliases();
                while (en.hasMoreElements()) {
                    message = String.valueOf(message) + (String) en.nextElement() + ";";
                }
                throw new Exception(message);
            }
            Certificate[] chain = this.keyStore.getCertificateChain(pkName);
            this.key = key;
            this.chain = chain;
        } catch (Exception e) {
            throw new Exception("initDevice error", e);
        } finally {
            try {
                if (fis != null) {
                    fis.close();
                }
            } catch (IOException e) {
                fis = null;
            }
        }
    }

    @Override
    public void destroy() {

    }

    @Override
    public byte[] sign(byte[] bytes) throws Exception {
        byte[] signedData = null;
        Signature signature = null;
        try {
            signature = Signature.getInstance("SHA256withRSA");
            signature.initSign(this.key);
            signature.update(bytes);
            signedData = signature.sign();
        } catch (Exception e) {
            throw new Exception("sign occur exception", e);
        }
        return signedData;
    }

    @Override
    public Object verify(byte[] bytes) throws Exception {
        return null;
    }

    @Override
    public Collection<Certificate> readCerts(byte[] contentsKey) throws Exception {
        try {
            X509CertParser x509CertParser = new X509CertParser();
            x509CertParser.engineInit(new ByteArrayInputStream(contentsKey));
            return x509CertParser.engineReadAll();
        } catch (Exception e) {
            return null;
        }
    }

}
