/*
 * $Id:  $
 *
 * This file is part of the jcar (R) project.
 * Copyright (c) 2014-2018 北京益高亚太信息技术有限公司
 * Authors: laurent.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License
 * as published by the Free Software Foundation, either version 3 of
 * the License, or(at your option)any later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 * or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU Affero General Public License for more details.
 * You should have received a copy of the GNU Affero General Public License
 * along with this program; if not, see <http://www.gnu.org/licenses>
 */
package com.indigopacific.module.policy;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.cert.Certificate;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.Collection;
import java.util.Iterator;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;


public class DigitalAssist {

	private static Log logger = LogFactory.getLog(DigitalAssist.class);


	public static byte[] streamToByteArray(InputStream rangeStream) throws Exception {
		ByteArrayOutputStream bos = null;
		byte[] result = null;
		try {
			bos = new ByteArrayOutputStream();
			byte[] buf = new byte[8192];
			int c;
			while ((c = rangeStream.read(buf)) != -1) {
				bos.write(buf, 0, c);
			}
			result = bos.toByteArray();
		} catch (IOException e) {
			logger.error("Stream to byteArray occur exception", e);
			throw e;
		} finally {
			try {
				if (bos != null) {
					bos.close();
				}
			} catch (IOException e) {
				bos = null;
			}
		}
		return result;
	}


	public static String createSignatureFieldName(String identity) {
		return "Signature[" + identity + "]";
	}


	public static String createSealFieldName(String identify, int sn) {
		return "Seal[" + identify + "][" + sn + "]";
	}


	public static String createErrorImageFieldName(String identify) {
		return "ErrorImage[" + identify + "]";
	}


	public static Certificate[] getCertificateArray(byte[] certificate) throws Exception {

		CertificateFactory cf = CertificateFactory.getInstance("X509");
		Collection<Certificate> col = (Collection<Certificate>) cf.generateCertificates(new ByteArrayInputStream(certificate));
		Certificate[] chain = new Certificate[col.size()];
		int i = 0;
		for (Iterator<Certificate> it = col.iterator(); it.hasNext();) {
			X509Certificate cert = (X509Certificate) it.next();
			chain[i++] = cert;
		}
		return chain;
	}
}
