/*
 * $Id:  $
 *
 * This file is part of the jcar (R) project.
 * Copyright (c) 2014-2018 北京益高亚太信息技术有限公司
 * Authors: laurent.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License
 * as published by the Free Software Foundation, either version 3 of
 * the License, or(at your option)any later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 * or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU Affero General Public License for more details.
 * You should have received a copy of the GNU Affero General Public License
 * along with this program; if not, see <http://www.gnu.org/licenses>
 */
package com.indigopacific.module.model;

import java.io.File;
import java.util.UUID;

import org.apache.log4j.Logger;
import org.dom4j.Element;
import org.dom4j.Node;

import com.indigopacific.module.policy.DigitalAssist;
import com.itextpdf.text.Rectangle;


public class Signature {

	@Override
	public String toString() {
		return "Signature [page=" + page + ", deviceName=" + deviceName + ", identify="
				+ identify + ", sourceFile="
						+ sourceFile + "]";
	}

	private static Logger logger = Logger.getLogger(Signature.class);

	protected String location = "";

	protected String reason = "make a signature";

	protected int certifyLevel = 0;

	protected int page = 1;

	protected Rectangle dimension;

	protected String signatureField;

	protected String device = "default";

	protected String contact = "Admin";

	protected String identify;

	protected String deviceName;

	protected String deviceVersion;

	protected String deviceType;

	protected Element deviceElement;

	protected String fileType;//Binary 需要传递源数据类型给下游接口
	
	protected String sourceFile;//签名文件
	
	
	protected String tsaName; //时间戳服务名称

	protected String tsaVersion; //时间戳服务版本

	protected String tsaType; //时间戳服务类型

	protected Element tsaElement;
	
	protected String font; //签名域字体指定

	
	public Signature(Element element) throws Exception {

		this.identify = UUID.randomUUID().toString();

		Node reason = element.element("Reason");
		if (reason != null) {
			this.reason = reason.getText();
		}

		Node location = element.selectSingleNode("Location");
		if (location != null) {
			this.location = location.getText();
		}

		Node contact = element.selectSingleNode("Contact");
		if (contact != null) {
			this.contact = contact.getText();
		}
		
		Node font = element.selectSingleNode("Font");
		if (font != null) {
			this.font = font.getText();
		}

		Element device = (Element) element.selectSingleNode("Device");
		if (device != null) {
			this.deviceName = device.attribute("name") != null?device.attribute("name").getText():"";
			this.deviceVersion = device.attribute("version") != null?device.attribute("version").getText():"";
			this.deviceType = device.attribute("type") != null?device.attribute("type").getText():null;
			this.deviceElement = device;
		}
		
		Element TSADevice = (Element) element.selectSingleNode("TSA");
		if (TSADevice != null) {
			this.tsaName = TSADevice.attribute("name") != null?TSADevice.attribute("name").getText():"";
			this.tsaVersion = TSADevice.attribute("version") != null?TSADevice.attribute("version").getText():"";
			this.tsaType = TSADevice.attribute("type") != null?TSADevice.attribute("type").getText():null;
			this.tsaElement = TSADevice;
		}

		Node certifyLevel = element.selectSingleNode("CertifyLevel");
		if (certifyLevel != null) {
			if(certifyLevel.getText().equals("1")
					||certifyLevel.getText().equals("2")
					||certifyLevel.getText().equals("3")
					||certifyLevel.getText().equals("0")){
				this.certifyLevel = Integer.parseInt(certifyLevel.getText());
			}else{
				throw new Exception("certifyLevel["+certifyLevel.getText()+"] is not valid");
			}
		}

		Node page = element.selectSingleNode("Page");
		if (page != null && !"".equals(page.getText())) {
			this.page = Integer.parseInt(page.getText());
		}

		Node lx = element.selectSingleNode("Dimension/LX");
		Node ly = element.selectSingleNode("Dimension/LY");
		Node rx = element.selectSingleNode("Dimension/RX");
		Node ry = element.selectSingleNode("Dimension/RY");

		if (lx != null && ly != null && rx != null && ry != null) {
			this.dimension = new Rectangle(Float.parseFloat(lx.getText()), Float.parseFloat(ly.getText()), Float.parseFloat(rx.getText()), Float.parseFloat(ry.getText()));
		}
		
		Node signatureField = element.selectSingleNode("SignatureField");
		if (signatureField != null && !"".equals(signatureField.getText())) {
			this.signatureField = signatureField.getText();
		}else{
			this.signatureField = DigitalAssist.createSignatureFieldName(this.identify);
		}

	}


	/**
	 * location getter
	 * @return location
	 */
	public String getLocation() {
		return location;
	}


	/**
	 * reason getter
	 * @return reason
	 */
	public String getReason() {
		return reason;
	}


	/**
	 * certifyLevel getter
	 * @return certifyLevel
	 */
	public int getCertifyLevel() {
		if (certifyLevel < 0 || certifyLevel > 3) {
			return 0;
		}
		return certifyLevel;
	}


	public int getPage() {
		return page;
	}


	public Rectangle getDimension() {
		return dimension;
	}


	public String getSignatureField() {
		return signatureField;
	}


	public void setSignatureField(String field) {
		this.signatureField = field;
	}


	public String getDevice() {
		return device;
	}


	public String getContact() {
		return contact;
	}


	public String getIdentify() {
		return identify;
	}


	public String getDeviceName() {
		return deviceName;
	}


	public String getDeviceVersion() {
		return deviceVersion;
	}


	public String getDeviceType() {
		return deviceType;
	}


	public Element getDeviceEle() {
		return deviceElement;
	}


	public String getFileType() {
		return fileType;
	}


	public void setFileType(String fileType) {
		this.fileType = fileType;
	}

	public void setSourceFile(Object in) {
		this.sourceFile = sourceFile;
	}

	public String getTsaName() {
		return tsaName;
	}

	public String getTsaVersion() {
		return tsaVersion;
	}

	public String getTsaType() {
		return tsaType;
	}

	public Element getTsaElement() {
		return tsaElement;
	}

	public String getFont() {
		return font;
	}

	public void setFont(String font) {
		this.font = font;
	}
}
