/*
 * $Id:  $
 *
 * This file is part of the jcar (R) project.
 * Copyright (c) 2014-2018 北京益高亚太信息技术有限公司
 * Authors: laurent.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License
 * as published by the Free Software Foundation, either version 3 of
 * the License, or(at your option)any later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 * or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU Affero General Public License for more details.
 * You should have received a copy of the GNU Affero General Public License
 * along with this program; if not, see <http://www.gnu.org/licenses>
 */
package com.indigopacific.customagent;

import com.indigopacific.module.model.SignVo;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;
import org.apache.velocity.Template;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.app.VelocityEngine;
import org.apache.velocity.context.Context;

import java.io.*;
import java.util.*;

public class SignatureAgent extends DSignature implements CustomAgentEx {

    private static Logger logger = Logger.getLogger(SignatureAgent.class);


    private Date startDate = null;

    private Date endDate = null;

    private String fileId = "";

    private String fileName = "";


    private String[] result = null;

    private String[] msg = null;


    private static String appHome = System.getProperty("APP_HOME");

    private static String stampPolicy = null;

    static{
        appHome = System.getProperty("APP_HOME");
        if(StringUtils.isBlank(appHome)){
            String currentDir = System.getProperty("user.dir");
            System.out.println("当前工作路径: " + currentDir);
            System.setProperty("APP_HOME", currentDir);
            appHome = currentDir;
        }

        stampPolicy = System.getProperty("stampPolicy");
        if(stampPolicy == null){
            stampPolicy = "default";
        }

        System.setProperty("SignatureDevice", appHome + File.separator + "Server" + File.separator + "SignatureDevice");
    }

    @Override
    public void execute(String[] args) throws Exception {

        this.startDate = new Date();
        String outPdf = args[1];
        String tempFile = args[0];
        String dirName = args[2];
        String templatePath = appHome + File.separator + "Server" + File.separator + "config";
        String ruleXmlFile = new File(templatePath, "rule_" + new File(tempFile).getName() + ".xml").getAbsolutePath();
        String templateFile = "template.vm";
        String outFile = outPdf;
        String signType = "PDF";
        for (int i = 0; i < args.length; i++) {
            logger.info("args[" + i + "]==" + args[i]);
        }

        try {
            List<SignVo> signList = new ArrayList<SignVo>();
            SignVo signVo = new SignVo();
            signVo.setDeviceIndex("device0");
            signVo.setDirName(dirName);
            signList.add(signVo);
            createRuleXml(ruleXmlFile, signList, dirName, templatePath, templateFile);
            logger.info("load xml");

            File sealFile = new File(new File(templatePath, "eseal"), dirName + ".png");

            try {
                String[] dsArgs = {
                        "-inFile", tempFile,
                        "-outFile", outFile,
                        "-log", "log",
                        "-fileType", "PDF",
                        "-workMode", "sign",
                        "-seal", sealFile.getAbsolutePath(),
                        "-multisign",
                        "-configFile", ruleXmlFile
                };
                dsignature(dsArgs);
            } catch (Exception e) {
                throw e;
            }
        } catch (Exception e) {
            e.printStackTrace();
            String errorMessage = e.getMessage();
            if (errorMessage != null && errorMessage.contains("enumerator.statistic error")) {
                throw e;
            }
            throw e;
        } finally {
            if (new File(ruleXmlFile).exists()) {
                FileUtils.deleteQuietly(new File(ruleXmlFile));
            }
        }
    }

    public void dsignature(String[] args) throws Exception {
        super.execute(args);
        this.endDate = new Date();
    }

    public void delete(String[] sealPaths, String[] cerPaths, String ruleXmlPath, String tempFile) {
        byte b;
        int i;
        String[] arrayOfString;
        for (i = (arrayOfString = sealPaths).length, b = 0; b < i; ) {
            String sealPath = arrayOfString[b];
            FileUtils.deleteQuietly(new File(sealPath));
            b++;
        }
        for (i = (arrayOfString = cerPaths).length, b = 0; b < i; ) {
            String cerPath = arrayOfString[b];
            FileUtils.deleteQuietly(new File(cerPath));
            b++;
        }
        FileUtils.deleteQuietly(new File(ruleXmlPath));
        FileUtils.deleteQuietly(new File(tempFile));
    }

    public void createRuleXml(String outPath, List signList, String dirName, String templatePath, String templateFile) throws Exception {
        VelocityContext context = new VelocityContext();
        context.put("signList", signList);
        context.put("dirName", dirName);
        context.put("APP_HOME", appHome);
        FileOutputStream fileOutputStream = null;
        BufferedWriter writer = null;
        Template template = null;
        VelocityEngine ve = null;
        Properties p = new Properties();
        p.setProperty("file.resource.loader.path", templatePath);
        p.setProperty("input.encoding", "UTF-8");
        p.setProperty("output.encoding", "UTF-8");
        OutputStreamWriter osw = null;
        try {
            ve = new VelocityEngine();
            ve.init(p);
//            template = ve.getTemplate(templatePath + File.separator + templateFile);
            template = ve.getTemplate(templateFile);
            logger.info("get template");
            fileOutputStream = new FileOutputStream(outPath);
            osw = new OutputStreamWriter(fileOutputStream, "UTF-8");
            writer = new BufferedWriter(osw);
            template.merge((Context)context, writer);
            logger.info("template merge");
            fileOutputStream.flush();
            osw.flush();
            writer.flush();
            if (fileOutputStream != null) {
                fileOutputStream.close();
                fileOutputStream = null;
            }
            if (osw != null) {
                osw.close();
                osw = null;
            }
            if (writer != null) {
                writer.close();
                writer = null;
            }
            logger.info("template merge final");
        } catch (Exception e) {
            throw e;
        } finally {
            if (fileOutputStream != null) {
                fileOutputStream.close();
                fileOutputStream = null;
            }
            if (osw != null) {
                osw.close();
                osw = null;
            }
            if (writer != null) {
                writer.close();
                writer = null;
            }
            p = null;
            template = null;
            ve = null;
            context = null;
        }
    }


    public Properties getPro(String confPath) throws Exception {
        FileInputStream fis = new FileInputStream(confPath);
        Properties pro = new Properties();
        try {
            pro.load(fis);
        } catch (Exception e) {
            e.printStackTrace();
        } finally {
            if (fis != null) {
                try {
                    fis.close();
                } catch (IOException e) {
                    fis = null;
                }
            }
        }
        return pro;
    }

    public void writeXMLtoFile(String xml, String filePath) throws IOException {
        try {
            ByteArrayInputStream bis = new ByteArrayInputStream(xml.getBytes("UTF-8"));
            FileOutputStream fos = new FileOutputStream(filePath);
            byte[] buff = new byte[1024];
            int i = 0;
            while ((i = bis.read(buff)) != -1) {
                fos.write(buff);
            }
            fos.flush();
            bis.close();
            fos.close();
        } catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
    }


    @Override
    public String getVersion() {
        return "2.0.1";
    }

}
