/*
 * $Id:  $
 *
 * This file is part of the jcar (R) project.
 * Copyright (c) 2014-2018 北京益高亚太信息技术有限公司
 * Authors: laurent.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License
 * as published by the Free Software Foundation, either version 3 of
 * the License, or(at your option)any later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 * or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU Affero General Public License for more details.
 * You should have received a copy of the GNU Affero General Public License
 * along with this program; if not, see <http://www.gnu.org/licenses>
 */
package com.indigopacific.customagent;
 
 import java.util.Map;
 import java.util.Set;
 import java.util.concurrent.ConcurrentHashMap;
 import java.util.concurrent.ConcurrentMap;
 import org.apache.log4j.Logger;



 public class RuntimeMonitorImpl
   implements RuntimeMonitor
 {
   static final Logger logger = Logger.getLogger(RuntimeMonitorImpl.class);
   
   private Long timeout = null;
 
 
   
   public void setTimeout(long timeout) { this.timeout = Long.valueOf(timeout); }
 
 
 
 
 
   
   private ConcurrentMap<String, AgentRuntimeMessage> messageMap = new ConcurrentHashMap();
 
 
   
   public void putMonitorMessage(String key, AgentRuntimeMessage monitorMessage) {
     if (!this.messageMap.containsKey(key)) {
       this.messageMap.put(key, monitorMessage);
     }
   }
 
 
 
   
   public void removeMonitorMessage(String key) { AgentRuntimeMessage monitorMessage = (AgentRuntimeMessage)this.messageMap.remove(key); }
 
 
 
   
   public MonitorResult getExceptionMessage() {
     long _timeOut = (this.timeout == null) ? 60L : this.timeout.longValue();
     int exceptionCount = 0;
     MonitorResult result = new MonitorResult();
     StringBuffer buffer = new StringBuffer();
     Set<Map.Entry<String, AgentRuntimeMessage>> set = this.messageMap.entrySet();
     for (Map.Entry<String, AgentRuntimeMessage> entry : set) {
       AgentRuntimeMessage runMsg = (AgentRuntimeMessage)entry.getValue();
       if (logger.isDebugEnabled())
         logger.debug("Monitor Test:agent=" + runMsg.getAgentName() + ";thread=" + runMsg.getThreadName() + ";当前耗时=" + runMsg.getDuration() + ";超时设定=" + _timeOut); 
       if (runMsg.getDuration() > _timeOut) {
         buffer.append(String.valueOf(runMsg.toString()) + System.getProperty("line.separator", "\n"));
         exceptionCount++;
       } 
     } 
     result.setCount(exceptionCount);
     result.setMessage(buffer.toString());
     return result;
   }
 }


