 /*
  * $Id:  $
  *
  * This file is part of the jcar (R) project.
  * Copyright (c) 2014-2018 北京益高亚太信息技术有限公司
  * Authors: laurent.
  *
  * This program is free software; you can redistribute it and/or modify
  * it under the terms of the GNU Affero General Public License
  * as published by the Free Software Foundation, either version 3 of
  * the License, or(at your option)any later version.
  *
  * This program is distributed in the hope that it will be useful, but
  * WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
  * or FITNESS FOR A PARTICULAR PURPOSE.
  * See the GNU Affero General Public License for more details.
  * You should have received a copy of the GNU Affero General Public License
  * along with this program; if not, see <http://www.gnu.org/licenses>
  */
package com.indigopacific.customagent;

import org.apache.log4j.Logger;

import java.io.IOException;
import java.nio.file.*;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.TimerTask;
import java.util.concurrent.ExecutorService;


public class PdfRotateScanTask extends TimerTask {

    private static Logger logger = Logger.getLogger(PdfRotateScanTask.class);


    String scanDir;
    String targetDir;

    private ExecutorService agent_threadpool;

    public PdfRotateScanTask(String scanDir, String targetDir, ExecutorService agent_threadpool) {
        this.scanDir = scanDir;
        this.targetDir = targetDir;
        this.agent_threadpool = agent_threadpool;
    }
    private static boolean isValidPdf(Path file) {
        return Files.isRegularFile(file) &&
                file.getFileName().toString().toLowerCase().endsWith(".pdf");
    }


    @Override
    public void run() {
        try {
            if (!Files.exists(Paths.get(targetDir))) {
                Files.createDirectories(Paths.get(targetDir));
            }
            logger.info("\n开始执行扫描任务...scanDir="+scanDir+" targetDir="+targetDir);
            long startTime = System.currentTimeMillis();
            // 执行扫描复制操作
            if(this.scanDir != null && !this.scanDir.equals("")){
                Path sourceDir = Paths.get(this.scanDir);
                Files.walkFileTree(sourceDir, new SimpleFileVisitor<Path>() {
                    @Override
                    public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) {
                        // 过滤PDF文件
                        if (isValidPdf(file)) {
                            try {
                                PdfRotatorAgent pdfRotatorAgent = new PdfRotatorAgent();
                                String rotationAngle = "90";
                                if (file != null && file.getFileName() != null) {
                                    String fileName = file.getFileName().toString();
                                    if (fileName.contains("_180_")) {
                                        rotationAngle = "180";
                                    } else if (fileName.contains("_270_")) {
                                        rotationAngle = "270";
                                    }
                                }
                                //加载文件标识
                                Path loadPath = file.resolveSibling(file.getFileName().toString() + ".load");
                                Files.move(file, loadPath, StandardCopyOption.ATOMIC_MOVE);

                                // 构造目标文件路径，包含业务参数
                                Path targetPath = Paths.get(targetDir, "out-" + file.getFileName().toString());

                                String[] paramArrayOfString1 = new String[]{
                                        loadPath.toString(),
                                        rotationAngle,
                                        targetPath.toString()};
                                logger.info("调用agent rotationAngle=" + rotationAngle + ";pdf=" + file.toString());
//                                pdfRotatorAgent.execute(paramArrayOfString1);
//                                Files.deleteIfExists(file);


                                Agent agentinfo = new Agent();
                                agentinfo.setAgentEx(pdfRotatorAgent);

                                agentinfo.setArgs(paramArrayOfString1);
                                agentinfo.setMsg(new Message());
                                agent_threadpool.submit(new AgentExecutor(agentinfo, loadPath));
                            }catch (Exception e){
                                logger.error("执行失败 [" + file + "]: " + e.getMessage());
                            }
                        }
                        return FileVisitResult.CONTINUE;
                    }

                    @Override
                    public FileVisitResult visitFileFailed(Path file, IOException exc) {
                        logger.info("无法访问文件: " + file);
                        return FileVisitResult.CONTINUE;
                    }
                });
            }

            long duration = System.currentTimeMillis() - startTime;
            System.out.printf("扫描完成，耗时%d毫秒%n", duration);
        } catch (Exception e) {
            System.err.println("扫描任务执行失败: " + e.getMessage());
        }
    }
}