 /*
  * $Id:  $
  *
  * This file is part of the jcar (R) project.
  * Copyright (c) 2014-2018 北京益高亚太信息技术有限公司
  * Authors: laurent.
  *
  * This program is free software; you can redistribute it and/or modify
  * it under the terms of the GNU Affero General Public License
  * as published by the Free Software Foundation, either version 3 of
  * the License, or(at your option)any later version.
  *
  * This program is distributed in the hope that it will be useful, but
  * WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
  * or FITNESS FOR A PARTICULAR PURPOSE.
  * See the GNU Affero General Public License for more details.
  * You should have received a copy of the GNU Affero General Public License
  * along with this program; if not, see <http://www.gnu.org/licenses>
  */
package com.indigopacific.customagent;
 
 import java.io.ByteArrayOutputStream;
 import java.io.PrintStream;




 public class PDFAgentExecutor
   implements Runnable
 {
   private String threadName;
   Agent agentinfo;
   
   public String getThreadName() { return this.threadName; }
 
 
 
   
   public PDFAgentExecutor setThreadName(String threadName) {
     this.threadName = threadName;
     return this;
   }
 
 
 
   
   public PDFAgentExecutor(Agent agent) { this.agentinfo = agent; }
 
   
   public void run() {
     Message msg = null;
     if (this.agentinfo != null) {
       CustomAgent agent1 = this.agentinfo.getAgent();
       CustomAgentEx agent2 = this.agentinfo.getAgentEx();
       String[] args = this.agentinfo.getArgs();
       msg = this.agentinfo.getMsg();
       try {
         if (agent2 != null) {
           agent2.execute(args);
         } else {
           agent1.execute(args);
         }  msg.setSuccess_flag(true);
         msg.write();
       } catch (Throwable e) {
         msg.setSuccess_flag(false);
         
         ByteArrayOutputStream bArrayOStream = new ByteArrayOutputStream();
         PrintStream pstream = new PrintStream(bArrayOStream);
         e.printStackTrace(pstream);
         
         String error = bArrayOStream.toString();
         error = error.replace("\r", "_");
         error = error.replace("\n", "_");
         error = error.replace("\t", "_");
         msg.setMessagecontent(error);
         
         try {
           msg.write();
         } catch (Exception e1) {
           System.exit(-1);
         } 
       } 
     } 
   }
 }


