
 /*
  * $Id:  $
  *
  * This file is part of the jcar (R) project.
  * Copyright (c) 2014-2018 北京益高亚太信息技术有限公司
  * Authors: laurent.
  *
  * This program is free software; you can redistribute it and/or modify
  * it under the terms of the GNU Affero General Public License
  * as published by the Free Software Foundation, either version 3 of
  * the License, or(at your option)any later version.
  *
  * This program is distributed in the hope that it will be useful, but
  * WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
  * or FITNESS FOR A PARTICULAR PURPOSE.
  * See the GNU Affero General Public License for more details.
  * You should have received a copy of the GNU Affero General Public License
  * along with this program; if not, see <http://www.gnu.org/licenses>
  */
package com.indigopacific.customagent;


 import java.io.IOException;


 public class Message {
   static final String msg_begin = "[JCAR_MSG_BEGIN]";
   static final String msg_end = "[JCAR_MSG_END]";
   static final String line_head = "[JCAR_MSG]";
   static final String success = "[SUCCESS]";
   static final String fail = "[FAIL]";
   private boolean success_flag = false;
   private String process_id;
   private String messagecontent;
   
   public String getMessagecontent() { return this.messagecontent; }
 
 
   
   public void setMessagecontent(String messagecontent) { this.messagecontent = messagecontent; }
 
 
   
   public String getProcess_id() { return this.process_id; }
 
 
   
   public void setProcess_id(String process_id) { this.process_id = process_id; }
 
 
   
   public boolean isSuccess_flag() { return this.success_flag; }
 
 
   
   public void setSuccess_flag(boolean success_flag) { this.success_flag = success_flag; }
 
   
   public void write() throws IOException {
     String vorf = "";
     if (this.success_flag) {
       vorf = "[SUCCESS]";
     } else {
       vorf = "[FAIL]";
     } 
     
     StringBuilder stringBuilder = new StringBuilder();
     stringBuilder.append("[JCAR_MSG][JCAR_MSG_BEGIN]" + vorf + this.process_id + "\n");
     if (this.messagecontent != null) {
       stringBuilder.append("[JCAR_MSG]" + this.messagecontent + "\n");
     }
     stringBuilder.append("[JCAR_MSG][JCAR_MSG_END]" + this.process_id + "\n");
     Jcar.logger.info(stringBuilder.toString());
   }
 
   
   public void write(String msg) throws IOException {
     if (msg == null || "".equals(msg)) {
       return;
     }
 
     
     StringBuilder stringbuilder = new StringBuilder();
     stringbuilder.append("[JCAR_MSG]" + msg + "\n");
     Jcar.logger.info(stringbuilder.toString());
   }
 }

