 /*
  * $Id:  $
  *
  * This file is part of the jcar (R) project.
  * Copyright (c) 2014-2018 北京益高亚太信息技术有限公司
  * Authors: laurent.
  *
  * This program is free software; you can redistribute it and/or modify
  * it under the terms of the GNU Affero General Public License
  * as published by the Free Software Foundation, either version 3 of
  * the License, or(at your option)any later version.
  *
  * This program is distributed in the hope that it will be useful, but
  * WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
  * or FITNESS FOR A PARTICULAR PURPOSE.
  * See the GNU Affero General Public License for more details.
  * You should have received a copy of the GNU Affero General Public License
  * along with this program; if not, see <http://www.gnu.org/licenses>
  */
package com.indigopacific.customagent;
 
 import java.io.BufferedReader;
 import java.io.IOException;
 import java.io.InputStreamReader;
 import java.io.OutputStream;
 import java.net.Socket;
 import java.net.UnknownHostException;

 public class JcarSocket {
   private Socket client = null;
   private BufferedReader reader = null;
   private OutputStream writer = null;
   public JcarSocket(int port) throws UnknownHostException, IOException {
     String ip = "127.0.0.1";
 
     
     this.client = new Socket(ip, port);
     this.reader = new BufferedReader(new InputStreamReader(this.client.getInputStream()));
     this.writer = this.client.getOutputStream();
     this.writer.write("JCAR\n".getBytes());
     this.writer.flush();
   }
   
   public String read() throws IOException {
     if (this.reader != null) {
       return this.reader.readLine();
     }
     
     throw new IOException("The Reader of Jcar is null.");
   }
 
   
   public void write(String contents) throws IOException {
     if (this.writer != null) {
       this.writer.write(contents.getBytes());
       this.writer.flush();
     } else {
       
       throw new IOException("The Writer of Jcar is null.");
     } 
   }
   public void destroy() throws IOException {
     try {
       if (this.writer != null) this.writer.close(); 
     } catch (Exception ex) {
       ex.printStackTrace();
     } 
     try {
       if (this.reader != null) this.reader.close(); 
     } catch (Exception ex) {
       ex.printStackTrace();
     } 
     if (this.client != null)
       this.client.close(); 
   }
 }


