/*
* $Id:  $
*
* This file is part of the jcar (R) project.
* Copyright (c) 2014-2018 北京益高亚太信息技术有限公司
* Authors: laurent.
*
* This program is free software; you can redistribute it and/or modify
* it under the terms of the GNU Affero General Public License
* as published by the Free Software Foundation, either version 3 of
* the License, or(at your option)any later version.
*
* This program is distributed in the hope that it will be useful, but
* WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
* or FITNESS FOR A PARTICULAR PURPOSE.
* See the GNU Affero General Public License for more details.
* You should have received a copy of the GNU Affero General Public License
* along with this program; if not, see <http://www.gnu.org/licenses>
*/
package com.indigopacific.customagent;

 import java.io.File;
 import java.io.IOException;
 import java.net.URISyntaxException;
 import java.net.URL;
 import java.net.URLDecoder;
 import java.util.LinkedList;
 import java.util.Timer;
 import java.util.concurrent.ExecutorService;
 import java.util.concurrent.Executors;
 import java.util.concurrent.SynchronousQueue;
 import java.util.concurrent.TimeUnit;

 import org.apache.log4j.Logger;
 import org.apache.log4j.PropertyConfigurator;


 public class Jcar {
     private static ExecutorService agent_threadpool;
     private static JcarSocket jsocket;
     public static String APP_HOME;
     static Logger logger = null;
     private static ClassLoader agentClassLoader = null;
     private static long loopTime = 20000L;
     static int maxSize = 16;
     static int maxCounter = 10;
     static int currentMaxCounter = 0;
     static float lastFailRadoi = 0.0F;
     static float resumeRadoi = 0.0F;
     static float maxFailRadoi = 50.0F;

     static boolean runnable = false;


     private static final long SCAN_INTERVAL = 20 * 1000; // 扫描间隔（毫秒）

     static Timer signatureTimer;

     static Timer rotateTimer;

     public static void main(String[] args) {
         String appPath = getAppPath();
         try {
             File courseFile = new File(String.valueOf(appPath) + "log4j.properties");
             PropertyConfigurator.configure(courseFile.getAbsolutePath());
         } catch (Exception ex) {
             ex.printStackTrace();
         }
         logger = Logger.getLogger(Jcar.class);
         logger.info("**************************【  JCar Start 】*******************************");
         String dirs = "";
         if (args.length > 0) {
             dirs = args[0];
         }
         try {
             if (!dirs.equals("") && !dirs.equals("none")) {
                 agentClassLoader = JCarClassLoader.createClassLoader(dirs, Thread.currentThread().getContextClassLoader());
                 Thread.currentThread().setContextClassLoader(agentClassLoader);
             } else {
                 agentClassLoader = Thread.currentThread().getContextClassLoader();
             }
         } catch (Exception e1) {
             logger.error(e1);
         }
         if (logger.isDebugEnabled()) {
             logger.debug("Jcar params length =" + args.length);
             StringBuffer parmasBuffer = new StringBuffer();
             for (int i = 0, l = args.length; i < l; i++) {
                 parmasBuffer.append(String.valueOf(args[i]) + " ");
             }
             logger.debug("Jcar params  = " + parmasBuffer.toString());
         }

         int defaultTimeout = 60;
         if (args.length >= 3) {
             defaultTimeout = Integer.parseInt(args[2]);
         }
         if (args.length >= 4) {
             maxSize = Integer.parseInt(args[3]);
         }
         if (args.length >= 5) {
             loopTime = (Integer.parseInt(args[4]) * 1000);
         }
         if (args.length >= 6) {
             APP_HOME = args[5];
         } else {
             APP_HOME = System.getenv("APP_HOME");
         }
         int port = 0;
         try {
             if (args.length > 1) {
                 port = Integer.parseInt(args[1]);
                 jsocket = new JcarSocket(port);
                 if (logger.isDebugEnabled()) {
                     logger.debug("create JcarSocket ok the port is " + port);
                 }
             }
         } catch (Exception e1) {
             logger.warn("jsocket start failed");
         }

         if (args.length >= 7) {
             maxCounter = Integer.parseInt(args[6]);
         }


         logger.info("JCar args：scan-dir=" + dirs + ";port=" + port + ";timeout=" + defaultTimeout + ";poolMaxSize=" + maxSize + ";monitroLoopTime=" + loopTime + ";APP_HOME=" + APP_HOME + ";maxCounter=" + maxCounter + " resumeRadoi=" + resumeRadoi);

         RuntimeMonitor monitor = startMonitor(logger, defaultTimeout);

         agent_threadpool = new IndigoThreadPoolExecutor(monitor, 0, maxSize, 60L, TimeUnit.SECONDS, new SynchronousQueue());
         String content = null;

         startWatchDir();

         if (jsocket != null) {
             while (true) {
                 try {
                     content = jsocket.read();
                     if (content == null) {
                         throw new Exception("socket read error");
                     }
                 } catch (Exception e) {
                     logger.error(e);
                     destroy();
                 }
                 if ("stop".equalsIgnoreCase(content)) {
                     try {
                         synchronized (monitor) {
                             try {
                                 monitor.notifyAll();
                             } catch (Exception exception) {
                             }
                         }
                     } catch (Exception ex) {
                         logger.error(ex);
                         destroy(0);
                     } finally {
                         destroy(0);
                     }
                 }
             }
         }else{
             while (true){
                 logger.info("jcar运行中......");
                 try {
                     Thread.sleep(10000);
                 }catch (Exception ex){

                 }
             }
         }

     }

     public static String getAppBaseDir() {
         try {
             // 尝试通过JAR路径获取
             String jarPath = Jcar.class.getProtectionDomain()
                     .getCodeSource().getLocation().toURI().getPath();
             File jarFile = new File(jarPath);

             if (jarPath.endsWith(".jar")) {
                 // JAR运行模式
                 return jarFile.getParentFile().getAbsolutePath();
             } else {
                 // IDE开发模式
                 return System.getProperty("user.dir");
             }
         } catch (URISyntaxException e) {
             return System.getProperty("user.dir");
         }
     }

     //扫描目录
     private static void startWatchDir() {
         String rootPath = (APP_HOME == null || APP_HOME.equals("")) ? getAppBaseDir() : APP_HOME;
         System.setProperty("APP_HOME", rootPath);
         String scanDir = rootPath + "/Server/data";
         String targetDir = rootPath + "/Server/temp";
         signatureTimer = new Timer("PDF扫描守护线程", true);
         signatureTimer.scheduleAtFixedRate(new PdfSignatureScanTask(scanDir, targetDir, agent_threadpool), 0, SCAN_INTERVAL);

         scanDir = rootPath + "/Server/data1";
         targetDir = rootPath + "/Server/temp1";
         rotateTimer = new Timer("PDFRotate扫描守护线程", true);
         rotateTimer.scheduleAtFixedRate(new PdfRotateScanTask(scanDir, targetDir, agent_threadpool), 0, SCAN_INTERVAL);
     }


     private static RuntimeMonitor startMonitor(final Logger logger, int defaultTimeout) {
         final RuntimeMonitor monitor = new RuntimeMonitorImpl();
         monitor.setTimeout(defaultTimeout);
         (new Thread(new Runnable() {
             boolean sendResume = false;

             public void run() {
                 while (runnable) {
                     Message msg = new Message();
                     msg.setProcess_id("RuntimeMonitor");
                     msg.setSuccess_flag(false);
                     String strMsg = "监控定时器运行";
                     logger.debug(strMsg);
                     MonitorResult result = monitor.getExceptionMessage();
                     int excCount = result.getCount();
                     float currentRadio = Float.parseFloat(String.valueOf(excCount)) / Float.parseFloat(String.valueOf(Jcar.maxSize)) * 100.0F;
                     if (excCount > 0) {
                         strMsg = "监控检测完成，上限线程数：" + Jcar.maxSize + "；异常Agent数量=" + excCount + ";异常比例上限：" + Jcar.maxFailRadoi + "%;异常比例:" + currentRadio + "%;具体信息：" + result.getMessage();
                         logger.error(strMsg);

                         if (currentRadio > Jcar.maxFailRadoi) {
                             this.sendResume = true;
                             Jcar.currentMaxCounter++;

                             if (Jcar.currentMaxCounter > Jcar.maxCounter) {
                                 strMsg = "连续超过阈值计数达到上限，JVM退出！ currentMaxCounter=" + Jcar.currentMaxCounter + " maxCounter=" + Jcar.maxCounter;
                                 logger.error(strMsg);
                                 Jcar.destroy();
                             }
                         }

                         if (currentRadio < Jcar.lastFailRadoi) {
                             Jcar.currentMaxCounter = 0;
                         }
                         if (excCount == Jcar.maxSize) {
                             strMsg = "线程池已经耗尽，JVM退出！";
                             logger.error(strMsg);
                             Jcar.destroy();
                         }
                     } else {

                         if (logger.isDebugEnabled()) {
                             strMsg = "监控检测完成，无异常信息！";
                             logger.debug(strMsg);
                         }
                     }

                     Jcar.lastFailRadoi = currentRadio;
                     synchronized (monitor) {
                         try {
                             monitor.wait(loopTime);
                         } catch (Exception e) {
                             logger.warn("monitor wait failed", e);
                         }
                     }
                 }
             }
         }
         )).start();
         return monitor;
     }


     public static ExecutorService getAgent_threadpool() {
         return agent_threadpool;
     }


     public static void setAgent_threadpool(ExecutorService agent_threadpool) {
         Jcar.agent_threadpool = agent_threadpool;
     }


     public static JcarSocket getJsocket() {
         return jsocket;
     }


     public static void setJsocket(JcarSocket jsocket) {
         Jcar.jsocket = jsocket;
     }


     public static String getAppPath() {
         URL url = Jcar.class.getProtectionDomain().getCodeSource().getLocation();
         String filePath = URLDecoder.decode(url.getPath());
         if (filePath.endsWith(".jar"))
             filePath = filePath.substring(0, filePath.lastIndexOf("/") + 1);
         File file = new File(filePath);
         return String.valueOf(file.getAbsolutePath()) + "/";
     }


     public static void destroy() {
         destroy(-1);
     }


     public static void destroy(int f) {
         logger.warn("ready invoke jcar.destroy");
         try {
             jsocket.destroy();
             jsocket = null;
             logger.warn("close job socket is ok!");
         } catch (Exception e1) {
             logger.error(e1);
         }

         try {
             if(signatureTimer != null){
                 signatureTimer.cancel();
                 signatureTimer = null;
                 logger.warn("close job signatureTimer is ok!");
             }

         } catch (Exception e1) {
             logger.error(e1);
         }

         try {
             if(rotateTimer != null){
                 rotateTimer.cancel();
                 rotateTimer = null;
                 logger.warn("close job rotateTimer is ok!");
             }

         } catch (Exception e1) {
             logger.error(e1);
         }

         try {
             jsocket.destroy();
             jsocket = null;
             logger.warn("close job socket is ok!");
         } catch (Exception e1) {
             logger.error(e1);
         }

         logger.warn("invoke System.exit(" + f + ")");
         System.gc();
         System.exit(f);
     }
 }


