 /*
  * $Id:  $
  *
  * This file is part of the jcar (R) project.
  * Copyright (c) 2014-2018 北京益高亚太信息技术有限公司
  * Authors: laurent.
  *
  * This program is free software; you can redistribute it and/or modify
  * it under the terms of the GNU Affero General Public License
  * as published by the Free Software Foundation, either version 3 of
  * the License, or(at your option)any later version.
  *
  * This program is distributed in the hope that it will be useful, but
  * WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
  * or FITNESS FOR A PARTICULAR PURPOSE.
  * See the GNU Affero General Public License for more details.
  * You should have received a copy of the GNU Affero General Public License
  * along with this program; if not, see <http://www.gnu.org/licenses>
  */
package com.indigopacific.customagent;
 
 import java.io.File;
 import java.net.URL;
 import java.net.URLClassLoader;
 import java.util.ArrayList;
 import java.util.List;
 import org.apache.log4j.Logger;


 public class JCarClassLoader
   extends URLClassLoader
 {
   static final Logger logger = Logger.getLogger(JCarClassLoader.class);

   public JCarClassLoader(URL[] repositories) { super(repositories); }

   public JCarClassLoader(URL[] repositories, ClassLoader parent) { super(repositories, parent); }

   public static ClassLoader createClassLoader(String value, ClassLoader parent) throws Exception {
     if (value == null || value.equals("")) {
       return parent;
     }
     
     List<File> dirs = load(value);
     
     ArrayList<String> repositoryLocations = new ArrayList<String>();
     ArrayList<Integer> repositoryTypes = new ArrayList<Integer>();
     
     for (File dir : dirs) {
       String repository = dir.getAbsolutePath();
       logger.debug("repository ： " + repository);
       
       repositoryLocations.add(repository);
       repositoryTypes.add(ClassLoaderFactory.IS_DIR);
       
       repositoryLocations.add(repository);
       repositoryTypes.add(ClassLoaderFactory.IS_GLOB);
     }
     String[] locations = (String[])repositoryLocations
       .toArray(new String[0]);
     Integer[] types = (Integer[])repositoryTypes
       .toArray(new Integer[0]);
     return ClassLoaderFactory.createClassLoader(locations, types, parent);
   }

   
   private static List<File> load(String pathArrString) throws Exception {
     List<File> dirs = new ArrayList<File>();
     if (pathArrString.contains(";")) {
       String[] tempArr = pathArrString.split(";"); byte b; int i; String[] arrayOfString;
       for (i  = tempArr.length, b = 0; b < i; ) {
         String path = tempArr[b];
         if (!path.equals("")) {
           File f = new File(path);
           if (f.exists())
             dirs.add(f); 
         }  b++; }
     
     } else {
       File f = new File(pathArrString);
       if (f.exists())
         dirs.add(f); 
     } 
     return dirs;
   }
 }


