 /*
  * $Id:  $
  *
  * This file is part of the jcar (R) project.
  * Copyright (c) 2014-2018 北京益高亚太信息技术有限公司
  * Authors: laurent.
  *
  * This program is free software; you can redistribute it and/or modify
  * it under the terms of the GNU Affero General Public License
  * as published by the Free Software Foundation, either version 3 of
  * the License, or(at your option)any later version.
  *
  * This program is distributed in the hope that it will be useful, but
  * WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
  * or FITNESS FOR A PARTICULAR PURPOSE.
  * See the GNU Affero General Public License for more details.
  * You should have received a copy of the GNU Affero General Public License
  * along with this program; if not, see <http://www.gnu.org/licenses>
  */
package com.indigopacific.customagent;
 
 import java.util.Date;
 import java.util.concurrent.BlockingQueue;
 import java.util.concurrent.RunnableFuture;
 import java.util.concurrent.ThreadPoolExecutor;
 import java.util.concurrent.TimeUnit;
 import org.apache.log4j.Logger;


 public class IndigoThreadPoolExecutor
   extends ThreadPoolExecutor
 {
   static final Logger logger = Logger.getLogger(IndigoThreadPoolExecutor.class);
   
   private RuntimeMonitor monitor = null;
 
   
   public IndigoThreadPoolExecutor(RuntimeMonitor monitor, int corePoolSize, int maximumPoolSize, long keepAliveTime, TimeUnit unit, BlockingQueue<Runnable> workQueue) {
     super(corePoolSize, maximumPoolSize, keepAliveTime, unit, workQueue);
     this.monitor = monitor;
   }
 
 
 
   
   protected <T> RunnableFuture<T> newTaskFor(Runnable runnable, T value) { return new IndigoFutureTask(runnable, value); }
 
 
 
 
   
   protected void beforeExecute(Thread t, Runnable r) {
     String threadName = t.getName();
     String agentName = getAgentName(r, threadName);
     AgentRuntimeMessage agentMsg = new AgentRuntimeMessage(agentName, threadName, new Date());
     agentMsg.setCurrentThread(t);
     this.monitor.putMonitorMessage(threadName, agentMsg);
     if (logger.isDebugEnabled()) {
       logger.debug("beforeExecute 添加监控记录：threadName=" + threadName + ";agentName=" + agentName);
     }
   }
   
   protected void afterExecute(Runnable r, Throwable t) {
     String threadName = getThreadName(r);
     String agentName = getAgentName(r, threadName);
     if (t == null) {
       this.monitor.removeMonitorMessage(threadName);
       if (logger.isDebugEnabled())
         logger.debug("afterExecute 移除监控记录：threadName=" + threadName + ";agentName=" + agentName); 
     } else {
       logger.error("afterExecute 异常Agent记录：threadName=" + threadName + ";agentName=" + agentName);
       logger.error(t);
     } 
   }
 
   
   private String getThreadName(Runnable r) {
     String threadName = "";
     if (r instanceof IndigoFutureTask) {
       Object excutor = ((IndigoFutureTask)r).getAgentExcutor();
       if (excutor instanceof AgentExecutor) {
         threadName = ((AgentExecutor)excutor).getThreadName();
       } else {
         threadName = ((PDFAgentExecutor)excutor).getThreadName();
       } 
     } 
     return threadName;
   }
 
   
   private String getAgentName(Runnable r, String threadName) {
     String agentName = "";
     CustomAgent customAgent = null;
     CustomAgentEx customAgentEx = null;
     if (r instanceof IndigoFutureTask) {
       
       Object excutor = ((IndigoFutureTask)r).getAgentExcutor();
       if (excutor instanceof AgentExecutor) {
         AgentExecutor agentExecutor = (AgentExecutor)excutor;
         if (threadName != null)
           agentExecutor.setThreadName(threadName); 
         customAgent = agentExecutor.getAgentInfo().getAgent();
         customAgentEx = agentExecutor.getAgentInfo().getAgentEx();
       } else {
         PDFAgentExecutor agentExecutor = (PDFAgentExecutor)excutor;
         if (threadName != null)
           agentExecutor.setThreadName(threadName); 
         customAgent = agentExecutor.agentinfo.getAgent();
         customAgentEx = agentExecutor.agentinfo.getAgentEx();
       } 
     } 
     if (customAgent != null) {
       agentName = customAgent.getClass().getName();
     } else if (customAgentEx != null) {
       agentName = customAgentEx.getClass().getName();
     }  return agentName;
   }
 }


