/*
 * $Id:  $
 *
 * This file is part of the jcar (R) project.
 * Copyright (c) 2014-2018 北京益高亚太信息技术有限公司
 * Authors: laurent.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License
 * as published by the Free Software Foundation, either version 3 of
 * the License, or(at your option)any later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 * or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU Affero General Public License for more details.
 * You should have received a copy of the GNU Affero General Public License
 * along with this program; if not, see <http://www.gnu.org/licenses>
 */
package com.indigopacific.customagent;

import java.io.File;
import java.util.HashMap;
import java.util.Map;

import com.indigosoftware.idp.component.agent.dsignature.IDPDSignature;
import org.apache.log4j.Logger;


public class DSignature implements CustomAgentEx {

	private static Logger logger = Logger.getLogger(DSignature.class);

	
	@Override
	public void execute(String[] args) throws Exception {

		Map<String, Object> parameters = changeStringArray2Map(args);
		if(!parameters.containsKey("isLocal")){
			parameters.put("isLocal", true);
		}
		
		IDPDSignature idpDsignature = new IDPDSignature();
		try{
			idpDsignature.execute(parameters);
		} catch (Exception e) {
			logger.error(e);
			throw e;
		}
		
	}


	public Map<String, Object> changeStringArray2Map(String[] args) throws Exception {
		Map<String, Object> parameters = new HashMap<String, Object>();
		for (int i = 0; i< args.length; i++) {
			String key = args[i];
			String value = null;
			if(i < args.length - 1){
				value = args[i + 1];
			}
			
			if(!key.startsWith("-")){
				throw new Exception("parameter:"+ key +" not start with - ");
			}
			if(value == null || value.startsWith("-")){
				parameters.put(key.substring(1), true);
			}else{
				parameters.put(key.substring(1), value);
				i++;
			}
			
			
		}
		
		return parameters;
	}

	@Override
	public String getVersion() {
		return "3.4.0";
	}

}
