/*
 * $Id:  $
 *
 * This file is part of the jcar (R) project.
 * Copyright (c) 2014-2018 北京益高亚太信息技术有限公司
 * Authors: laurent.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License
 * as published by the Free Software Foundation, either version 3 of
 * the License, or(at your option)any later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 * or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU Affero General Public License for more details.
 * You should have received a copy of the GNU Affero General Public License
 * along with this program; if not, see <http://www.gnu.org/licenses>
 */

package com.indigopacific.customagent;
 
 import java.util.LinkedList;

 public class CommondParser {
   public static LinkedList<String> ParseCmdPara(String cmdpara) {
     LinkedList<String> paras = new LinkedList<String>();
     String cmd = String.valueOf(cmdpara) + " ";
     String cur = "";
     
     char flag = 'S';
     
     for (int i = 0; i < cmd.length(); i++) {
       char c = cmd.charAt(i);
       if (c == '"') {
         if (flag == 'S') {
           flag = 'P';
         } else if (flag == 'P') {
           flag = 'Q';
           paras.add(cur);
           cur = "";
         } else {
           return null;
         } 
       } else if (c == ' ' || c == '\t') {
         if (flag != 'S')
         {
           if (flag == 'P') {
             cur = String.valueOf(cur) + c;
           } else if (flag == 'Q') {
             flag = 'S';
           } else {
             flag = 'S';
             paras.add(cur);
             cur = "";
           } 
         }
       } else if (flag == 'S') {
         flag = 'A';
         cur = String.valueOf(cur) + c;
       } else if (flag == 'P') {
         cur = String.valueOf(cur) + c;
       } else if (flag == 'A') {
         cur = String.valueOf(cur) + c;
       } else if (flag == 'Q') {
         return null;
       } 
     } 
     
     return paras;
   }
 
   
   public static String[] convert1D(LinkedList<String> list) {
     if (list.size() == 0)
     {
       return null;
     }
     
     String[] result = new String[list.size()];
     for (int i = 0; i < list.size(); i++) {
       result[i] = (String)list.get(i);
     }
 
 
 
     
     return result;
   }
 
 
 
   
   public static void main(String[] args) { ParseCmdPara(" \"sdf\" [process_id] IPMTest -u 'username' -p password"); }
 }


