/*
 * $Id:  $
 *
 * This file is part of the jcar (R) project.
 * Copyright (c) 2014-2018 北京益高亚太信息技术有限公司
 * Authors: laurent.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License
 * as published by the Free Software Foundation, either version 3 of
 * the License, or(at your option)any later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 * or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU Affero General Public License for more details.
 * You should have received a copy of the GNU Affero General Public License
 * along with this program; if not, see <http://www.gnu.org/licenses>
 */

package com.indigopacific.customagent;
 
 import java.io.File;
 import java.net.URL;
 import java.util.LinkedHashSet;
 import java.util.Set;
 import org.apache.log4j.Logger;


 public final class ClassLoaderFactory
 {
   static final Logger log = Logger.getLogger(ClassLoaderFactory.class);
   
   protected static final Integer IS_DIR = new Integer(0);
   
   protected static final Integer IS_JAR = new Integer(1);
   
   protected static final Integer IS_GLOB = new Integer(2);
   
   protected static final Integer IS_URL = new Integer(3);
 
 
 
   
   public static ClassLoader createClassLoader(File[] unpacked, File[] packed, ClassLoader parent) throws Exception { return createClassLoader(unpacked, packed, null, parent); }
 
 
 
   
   public static ClassLoader createClassLoader(File[] unpacked, File[] packed, URL[] urls, ClassLoader parent) throws Exception {
     if (log.isDebugEnabled()) {
       log.debug("Creating new class loader");
     }
     
     Set set = new LinkedHashSet();
     
     if (unpacked != null) {
       for (int i = 0; i < unpacked.length; i++) {
         File file = unpacked[i];
         if (file.exists() && file.canRead()) {
           
           file = new File(String.valueOf(file.getCanonicalPath()) + File.separator);
           URL url = file.toURI().toURL();
           if (log.isDebugEnabled())
             log.debug("  Including directory " + url); 
           set.add(url);
         } 
       } 
     }
     
     if (packed != null) {
       for (int i = 0; i < packed.length; i++) {
         File directory = packed[i];
         if (directory.isDirectory() && directory.exists() && 
           directory.canRead()) {
 
           
           String[] filenames = directory.list();
           for (int j = 0; j < filenames.length; j++) {
             String filename = filenames[j].toLowerCase();
             if (filename.endsWith(".jar")) {
               
               File file = new File(directory, filenames[j]);
               if (log.isDebugEnabled())
                 log.debug("  Including jar file " + 
                     file.getAbsolutePath()); 
               URL url = file.toURI().toURL();
               set.add(url);
             } 
           } 
         } 
       } 
     }
     URL[] array = (URL[])set.toArray(new URL[set.size()]);
     JCarClassLoader classLoader = null;
     if (parent == null) {
       classLoader = new JCarClassLoader(array);
     } else {
       classLoader = new JCarClassLoader(array, parent);
     } 
     return classLoader;
   }
 
 
   
   public static ClassLoader createClassLoader(String[] locations, Integer[] types, ClassLoader parent) throws Exception {
     if (log.isDebugEnabled()) {
       log.debug("Creating new class loader");
     }
     
     Set set = new LinkedHashSet();
     
     if (locations != null && types != null && 
       locations.length == types.length)
       for (int i = 0; i < locations.length; i++) {
         String location = locations[i];
         if (types[i] == IS_URL) {
           URL url = new URL(location);
           if (log.isDebugEnabled())
             log.debug("  Including URL " + url); 
           set.add(url);
         } else if (types[i] == IS_DIR) {
           File directory = new File(location);
           directory = new File(directory.getCanonicalPath());
           if (directory.exists() && directory.isDirectory() && 
             directory.canRead())
           
           { 
             URL url = directory.toURI().toURL();
             if (log.isDebugEnabled())
               log.debug("  Including directory " + url); 
             set.add(url); } 
         } else if (types[i] == IS_JAR) {
           File file = new File(location);
           file = new File(file.getCanonicalPath());
           if (file.exists() && file.canRead())
           
           { URL url = file.toURI().toURL();
             if (log.isDebugEnabled())
               log.debug("  Including jar file " + url); 
             set.add(url); } 
         } else if (types[i] == IS_GLOB) {
           File directory = new File(location);
           if (directory.exists() && directory.isDirectory() && 
             directory.canRead()) {
 
             
             if (log.isDebugEnabled()) {
               log.debug("  Including directory glob " + 
                   directory.getAbsolutePath());
             }
             String[] filenames = directory.list();
             for (int j = 0; j < filenames.length; j++) {
               String filename = filenames[j].toLowerCase();
               if (filename.endsWith(".jar")) {
                 
                 File file = new File(directory, filenames[j]);
                 file = new File(file.getCanonicalPath());
                 if (file.exists() && file.canRead()) {
                   
                   if (log.isDebugEnabled()) {
                     log.debug("    Including glob jar file " + 
                         file.getAbsolutePath());
                   }
                   URL url = file.toURI().toURL();
                   set.add(url);
                 } 
               } 
             } 
           } 
         } 
       }   URL[] array = (URL[])set.toArray(new URL[set.size()]);
     if (log.isDebugEnabled())
       for (int i = 0; i < array.length; i++) {
         log.debug("  location " + i + " is " + array[i]);
       } 
     JCarClassLoader classLoader = null;
     if (parent == null) {
       classLoader = new JCarClassLoader(array);
     } else {
       classLoader = new JCarClassLoader(array, parent);
     } 
     return classLoader;
   }
 }


