/*
 * $Id:  $
 *
 * This file is part of the jcar (R) project.
 * Copyright (c) 2014-2018 北京益高亚太信息技术有限公司
 * Authors: laurent.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License
 * as published by the Free Software Foundation, either version 3 of
 * the License, or(at your option)any later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 * or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU Affero General Public License for more details.
 * You should have received a copy of the GNU Affero General Public License
 * along with this program; if not, see <http://www.gnu.org/licenses>
 */

package com.indigopacific.customagent;
 
 import java.text.SimpleDateFormat;
 import java.util.Date;


 public class AgentRuntimeMessage
 {
   private String agentName;
   private String threadName;
   private Date startTime;
   private Date endTime;
   private String duration;
   private Thread currentThread;
   
  public Thread getCurrentThread() { return this.currentThread; }
 
 
   
   public void setCurrentThread(Thread currentThread) { this.currentThread = currentThread; }
 
 
   
  public String getAgentName() { return this.agentName; }
 
   
   public String getThreadName() { return this.threadName; }
   public AgentRuntimeMessage(String agentName, String threadName, Date startTime) {
     this.endTime = null;
     this.agentName = agentName;
    this.threadName = threadName;
    this.startTime = startTime;
   }
 
   
  public void setEndTime(Date endTime) { this.endTime = endTime; }
 
 
   
   public Date getEndTime() { return this.endTime; }
 
 
 
   
   public long getDuration() {
     Date _endTime = this.endTime;
    if (this.endTime == null) {
      _endTime = new Date();
     }
    return (_endTime.getTime() - this.startTime.getTime()) / 1000L;
   }
 
 
   
   public String toString() {
    Date _endTime = this.endTime;
    SimpleDateFormat f = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
     String strEndTime = "异常";
     String traceDetails = "";
    if (this.endTime == null) {
       this.duration = "异常";
       _endTime = new Date();
      traceDetails = getStackTrace(getCurrentThread());
     } 
     strEndTime = f.format(_endTime);
     long l = _endTime.getTime() - this.startTime.getTime();
     long day = l / 86400000L;
   long hour = l / 3600000L - day * 24L;
     long min = l / 60000L - day * 24L * 60L - hour * 60L;
    long s = l / 1000L - day * 24L * 60L * 60L - hour * 60L * 60L - min * 60L;
    long ms = l - day * 24L * 60L * 60L * 1000L - hour * 60L * 60L * 1000L - min * 60L * 1000L - s * 1000L;
     this.duration = String.valueOf(day) + "天" + hour + "小时" + min + "分" + s + "秒" + ms + "毫秒" + System.getProperty("line.separator");
     String strStartTime = f.format(this.startTime);
     return "线程名称=" + this.threadName + ";AgentName=" + this.agentName + ";任务开始时间=" + strStartTime + ";任务结束时间=" + strEndTime + ";已耗时=" + this.duration + traceDetails;
   }
   
   private String getStackTrace(Thread thread) {
     StringBuilder builder = new StringBuilder();
     if (thread == null) {
       return builder.toString();
     }
     StackTraceElement[] stackTraceElements = thread.getStackTrace();
     
     builder.append(String.valueOf(System.getProperty("line.separator")) + "StackTrace: The stackTraceElements length: " + stackTraceElements.length);
     for (int i = 0; i < stackTraceElements.length; i++) {
       builder.append("\r\n");
       builder.append(stackTraceElements[i].toString());
     } 
     return builder.toString();
   }
 }


