# jcar

#### 介绍

 基于Java开发的轻量级独立服务，通过文件目录监听扫描任务，提供专业PDF文档处理能力，包括PDF的旋转、签名、签章功能

#### 软件架构

 基于JDK6及以上版本,独立运行的Java服务


#### 安装教程

1.  通过com.indigopacific.customagent.Jcar入口类main函数启动服务
2.  建议内存设置2G以上




#### 使用说明

##### 文件夹扫描方式处理PDF签名

    jcar内置对PDF签名的文件夹扫描方式，可以通过环境变量APP_HOME配置扫描待签名文档的根目录
    
    文件扫描目录为APP_HOME/Server/data/${keyName}
    扫描获取文件为待签名的PDF，例如：
    1.  扫描文件为：test.pdf
    处理后文件输出的目录为 APP_HOME/Server/temp/${keyName}
    定时器每隔一分钟会扫描APP_HOME/Server/data目录下所有子目录的PDF文件，扫描到PDF文件后执行签名，并输出到APP_HOME/Server/temp目录
    文件被处理后，APP_HOME/Server/data目录下的源PDF文件会被移除
    APP_HOME/Server/temp/${keyName}会输出处理结果文件 ：out-xxx.pdf， 例如：out-test.pdf



##### 文件夹扫描方式处理PDF签章

    jcar内置对PDF签章的文件夹扫描方式，可以通过环境变量APP_HOME配置待签章文档根目录
    
    文件扫描目录为APP_HOME/Server/data/${keyName}，相比于签名功能，如果存在同名APP_HOME/Server/config/eseal/${keyName}.png文件，则该目录下
    扫描获取文件为待签章的PDF；APP_HOME/Server/config/eseal/${keyName}.png为印章图片，APP_HOME/Server/config/eseal/${keyName}.xml为签章位置配置文件，例如：
    1.  扫描文件为：test.pdf
    处理后文件输出的目录为 APP_HOME/Server/temp/${keyName}
    定时器每隔一分钟会扫描APP_HOME/Server/data目录下所有子目录的PDF文件，扫描到PDF文件后执行签章，并输出到APP_HOME/Server/temp目录
    文件被处理后，APP_HOME/Server/data目录下的源PDF文件会被移除
    APP_HOME/Server/temp/${keyName}会输出处理的结果文件 ：out-xxx.pdf， 例如：out-test.pdf



##### 文件夹扫描方式处理PDF旋转

    jcar内置对PDF旋转的文件夹扫描方式，可以通过环境变量APP_HOME配置待旋转文档扫描的根目录
    
    文件扫描目录为APP_HOME/Server/data1
    扫描获取文件为待旋转的PDF，例如：
    1.  扫描文件为：test.pdf
    处理后文件输出的目录为 APP_HOME/Server/temp1
    定时器每隔一分钟会扫描APP_HOME/Server/data1目录，扫描到PDF文件后执行旋转，并输出到 APP_HOME/Server/temp1目录
    默认按90度旋转，可以通过文件名中设置_180_指定180度旋转，_270_指定270度旋转
    文件被处理后，APP_HOME/Server/data1源文件会被移除
    APP_HOME/Server/temp1会输出处理的结果文件 ：out-xxx.pdf，例如：out-test.pdf




#### PDF签名配置

签名配置可以使用APP_HOME/Server/config/template.vm模板配置，详细配置如下：

template.vm 模板文件样例

```xml
<?xml version="1.0" encoding="UTF-8"?>
<DigitalSignature>
			<!--签章位置信息-->
			#foreach($sign in $signList)
	<Signature>
			<Reason>Reason</Reason>
			<Contact>Contact</Contact>
			<Location>Location</Location>
			<Device name="$sign.deviceIndex" type="com.indigosoftware.adapter.jce.IndigoSoftwareJCEAdapter">
				<pkFile>$APP_HOME\Server\config\ecertFile\RSA\\${sign.dirName}.keystore</pkFile>
				<ksPWD>123456</ksPWD>
##				<pkName>indigorsa</pkName>
				<pkName>test</pkName>
				<pkPWD>123456</pkPWD>
				<ksType>jks</ksType>
				<digestType>SHA1</digestType>
				<signType>RSA</signType>
			</Device>
	</Signature>
			#end

</DigitalSignature>
```

注意：

1.  pkFile指定了签名证书存储文件绝对路径，VM模板中支持变量APP_HOME为服务工作根路径；变量dirName为扫描获取PDF文件的目录名；

例如上文样例中，PDF扫描路径为APP_HOME/Server/data/${keyName}，则证书文件存证路径为APP_HOMEServer\config\ecertFile\RSA\\${sign.dirName}.keystore

dirName变量值为扫描PDF文件所在目录名，例如测试数据中的dirName=test-1



2. APP_HOME/Server/config目录为资源和配置信息目录，ecertFile目录存放证书文件，eseal目录存放印章图片文件，以及对应的签章位置配置文件。

3. PDF扫描目录同名印章文件APP_HOME/Server/config/eseal/${keyName}.png为PNG格式印章图片，同名文件APP_HOME/Server/config/eseal/${keyName}.xml为签章位置配置文件，详细格式说明如下：

   ```
   <?xml version="1.0" encoding="UTF-8"?>
   <Seal>
       <!-- 签名域左下角X坐标，单位mm-->
       <X></X>
       <!-- 签名域左下角Y坐标，单位mm-->
       <Y></Y>
       <!-- 印章签名域内X坐标，单位mm-->
       <OffsetX></OffsetX>
       <!-- 印章签名域内Y坐标，单位mm-->
       <OffsetY></OffsetY>
       <!-- 签名域宽度，应与印章图片相同，单位mm-->
       <Width>45</Width>
       <!-- 签名域高度度，应与印章图片相同，单位mm-->
       <Height>45</Height>
       <!-- 文本匹配位置用印指定用印文字串-->
       <Key>第一页</Key>
       <!-- 文本匹配用印时用印位置对齐方式，0文字左下角对齐用印，1文字中心位置用印，2 文字右下角对齐用印-->
       <Align>2</Align>
       <!-- 印章图片分辨率-->
       <Dpi>600</Dpi>
   </Seal>
   ```

   



#### 启动脚本实例


```
#!/bin/sh
port=$1     # 服务停用指令监听端口
timeout=60  # 单个任务最大执行时长，单位秒
poolMaxSize=16  # 工作线程数
monitorLoopTime=15   # 任务监听线程工作间隔时间，单位秒
maxCounter=8       # 任务监控最大出错次数阈值


APP_HOME="/home/jcar"  # 工作空间根目录
agentPath='none'    # 扩展业务包加载路径

JAR_FILE="$APP_HOME/jcar.jar"

echo $JAVA_HOME/bin/java

echo 'start jcar ......'

$JAVA_HOME/bin/java -Xms1024m -Xmx2048m -XX:PermSize=128m -XX:MaxPermSize=256m  -XX:-OmitStackTraceInFastThrow -DDigitalSignature.CacheFormCount=200  -DSignatureDevice=$APP_HOME/Server/SignatureDevice/ -XX:+HeapDumpOnOutOfMemoryError -XX:ErrorFile=$IDG_HOME/logs/hs_err_pid.log -XX:+PrintGCDetails -XX:+PrintGCDateStamps -XX:+PrintTenuringDistribution -XX:+PrintGCApplicationStoppedTime -XX:NativeMemoryTracking=detail -Xloggc:$APP_HOME/logs/gc.log -cp $JAR_FILE com.indigopacific.customagent.Jcar $agentPath $port $timeout $poolMaxSize $monitorLoopTime $APP_HOME $maxCounter

```





